/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.CreateClusterRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.ClusterAutoscalingConfig;
import com.google.cloud.bigtable.admin.v2.models.StaticClusterSize;
import com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class CreateClusterRequest {
    private final CreateClusterRequest.Builder proto = com.google.bigtable.admin.v2.CreateClusterRequest.newBuilder();
    private final String instanceId;
    private String zone;

    public static CreateClusterRequest of(String instanceId, String clusterId) {
        return new CreateClusterRequest(instanceId, clusterId);
    }

    private CreateClusterRequest(String instanceId, String clusterId) {
        this.instanceId = instanceId;
        this.proto.setClusterId(clusterId);
        this.proto.getClusterBuilder().setDefaultStorageType(StorageType.SSD.toProto());
    }

    public CreateClusterRequest setZone(String zone) {
        this.zone = zone;
        return this;
    }

    @Deprecated
    public CreateClusterRequest setServeNodes(int numNodes) {
        this.proto.getClusterBuilder().setServeNodes(numNodes);
        return this;
    }

    public CreateClusterRequest setScalingMode(@Nonnull StaticClusterSize staticClusterSize) {
        Preconditions.checkState((staticClusterSize.getClusterSize() > 0 ? 1 : 0) != 0, (Object)"Serve nodes must be > 0");
        if (this.proto.getCluster().getClusterConfig().hasClusterAutoscalingConfig()) {
            throw new IllegalArgumentException("Autoscaling is already set. To enable manual scaling, do not set the max nodes, min nodes, and CPU percentage.");
        }
        this.proto.getClusterBuilder().setServeNodes(staticClusterSize.getClusterSize());
        return this;
    }

    public CreateClusterRequest setScalingMode(@Nonnull ClusterAutoscalingConfig autoscalingConfig) {
        int minNodes = autoscalingConfig.getMinNodes();
        int maxNodes = autoscalingConfig.getMaxNodes();
        int cpuTargetPercent = autoscalingConfig.getCpuUtilizationTargetPercent();
        int storageUtilizationGibPerNode = autoscalingConfig.getStorageUtilizationGibPerNode();
        this.proto.getClusterBuilder().getClusterConfigBuilder().getClusterAutoscalingConfigBuilder().getAutoscalingLimitsBuilder().setMinServeNodes(minNodes);
        this.proto.getClusterBuilder().getClusterConfigBuilder().getClusterAutoscalingConfigBuilder().getAutoscalingLimitsBuilder().setMaxServeNodes(maxNodes);
        this.proto.getClusterBuilder().getClusterConfigBuilder().getClusterAutoscalingConfigBuilder().getAutoscalingTargetsBuilder().setCpuUtilizationPercent(cpuTargetPercent);
        this.proto.getClusterBuilder().getClusterConfigBuilder().getClusterAutoscalingConfigBuilder().getAutoscalingTargetsBuilder().setStorageUtilizationGibPerNode(storageUtilizationGibPerNode);
        return this;
    }

    public CreateClusterRequest setStorageType(@Nonnull StorageType storageType) {
        Preconditions.checkNotNull((Object)((Object)storageType));
        Preconditions.checkArgument((storageType != StorageType.UNRECOGNIZED ? 1 : 0) != 0, (Object)"StorageType can't be UNRECOGNIZED");
        this.proto.getClusterBuilder().setDefaultStorageType(storageType.toProto());
        return this;
    }

    public CreateClusterRequest setKmsKeyName(@Nonnull String kmsKeyName) {
        Preconditions.checkNotNull((Object)kmsKeyName);
        this.proto.getClusterBuilder().getEncryptionConfigBuilder().setKmsKeyName(kmsKeyName);
        return this;
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateClusterRequest toProto(String projectId) {
        this.proto.setParent(NameUtil.formatInstanceName(projectId, this.instanceId));
        this.proto.getClusterBuilder().setLocation(NameUtil.formatLocationName(projectId, this.zone));
        return this.proto.build();
    }

    @InternalApi
    String getClusterId() {
        return this.proto.getClusterId();
    }

    @InternalApi
    Cluster toEmbeddedProto(String projectId) {
        this.proto.getClusterBuilder().setLocation(NameUtil.formatLocationName(projectId, this.zone));
        return this.proto.getClusterBuilder().build();
    }
}

