/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiException;
import io.grpc.Status;
import org.threeten.bp.Duration;

@InternalApi
public class ApiResultRetryAlgorithm<ResponseT>
implements ResultRetryAlgorithm<ResponseT> {
    public static final Duration DEADLINE_SLEEP_DURATION = Duration.ofMillis((long)1L);

    private boolean isRetryableStatus(Status status) {
        return status.getCode() == Status.Code.INTERNAL && status.getDescription() != null && (status.getDescription().contains("Received unexpected EOS on DATA frame from server") || status.getDescription().contains("Received Rst Stream"));
    }

    public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, ResponseT prevResponse, TimedAttemptSettings prevSettings) {
        Status status;
        if (prevThrowable != null && this.isRetryableStatus(status = Status.fromThrowable((Throwable)prevThrowable))) {
            return TimedAttemptSettings.newBuilder().setGlobalSettings(prevSettings.getGlobalSettings()).setRetryDelay(prevSettings.getRetryDelay()).setRpcTimeout(prevSettings.getRpcTimeout()).setRandomizedRetryDelay(DEADLINE_SLEEP_DURATION).setAttemptCount(prevSettings.getAttemptCount() + 1).setFirstAttemptStartTimeNanos(prevSettings.getFirstAttemptStartTimeNanos()).build();
        }
        return null;
    }

    public boolean shouldRetry(Throwable prevThrowable, ResponseT prevResponse) {
        Status status;
        if (prevThrowable != null && this.isRetryableStatus(status = Status.fromThrowable((Throwable)prevThrowable))) {
            return true;
        }
        return prevThrowable instanceof ApiException && ((ApiException)prevThrowable).isRetryable();
    }
}

