/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableResult;
import javax.annotation.Nullable;

final class AutoValue_TableResult
extends TableResult {
    @Nullable
    private final Schema schema;
    private final long totalRows;
    private final Page<FieldValueList> pageNoSchema;
    @Nullable
    private final JobId jobId;
    @Nullable
    private final String queryId;
    private static final long serialVersionUID = 1L;

    private AutoValue_TableResult(@Nullable Schema schema, long totalRows, Page<FieldValueList> pageNoSchema, @Nullable JobId jobId, @Nullable String queryId) {
        this.schema = schema;
        this.totalRows = totalRows;
        this.pageNoSchema = pageNoSchema;
        this.jobId = jobId;
        this.queryId = queryId;
    }

    @Override
    @Nullable
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public long getTotalRows() {
        return this.totalRows;
    }

    @Override
    public Page<FieldValueList> getPageNoSchema() {
        return this.pageNoSchema;
    }

    @Override
    @Nullable
    public JobId getJobId() {
        return this.jobId;
    }

    @Override
    @Nullable
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public TableResult.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TableResult.Builder {
        private Schema schema;
        private long totalRows;
        private Page<FieldValueList> pageNoSchema;
        private JobId jobId;
        private String queryId;
        private byte set$0;

        Builder() {
        }

        private Builder(TableResult source) {
            this.schema = source.getSchema();
            this.totalRows = source.getTotalRows();
            this.pageNoSchema = source.getPageNoSchema();
            this.jobId = source.getJobId();
            this.queryId = source.getQueryId();
            this.set$0 = 1;
        }

        @Override
        public TableResult.Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public TableResult.Builder setTotalRows(Long totalRows) {
            if (totalRows == null) {
                throw new NullPointerException("Null totalRows");
            }
            this.totalRows = totalRows;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public TableResult.Builder setPageNoSchema(Page<FieldValueList> pageNoSchema) {
            if (pageNoSchema == null) {
                throw new NullPointerException("Null pageNoSchema");
            }
            this.pageNoSchema = pageNoSchema;
            return this;
        }

        @Override
        public TableResult.Builder setJobId(JobId jobId) {
            this.jobId = jobId;
            return this;
        }

        @Override
        public TableResult.Builder setQueryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public TableResult build() {
            if (this.set$0 != 1 || this.pageNoSchema == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" totalRows");
                }
                if (this.pageNoSchema == null) {
                    missing.append(" pageNoSchema");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TableResult(this.schema, this.totalRows, this.pageNoSchema, this.jobId, this.queryId);
        }
    }
}

