package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SnapshotTableDefinition extends SnapshotTableDefinition {

  private final TableDefinition.Type type;

  private final Schema schema;

  private final TableId baseTableId;

  private final String snapshotTime;

  private final TimePartitioning timePartitioning;

  private final RangePartitioning rangePartitioning;

  private final Clustering clustering;

  private AutoValue_SnapshotTableDefinition(
      TableDefinition.Type type,
      @Nullable Schema schema,
      @Nullable TableId baseTableId,
      @Nullable String snapshotTime,
      @Nullable TimePartitioning timePartitioning,
      @Nullable RangePartitioning rangePartitioning,
      @Nullable Clustering clustering) {
    this.type = type;
    this.schema = schema;
    this.baseTableId = baseTableId;
    this.snapshotTime = snapshotTime;
    this.timePartitioning = timePartitioning;
    this.rangePartitioning = rangePartitioning;
    this.clustering = clustering;
  }

  @Override
  public TableDefinition.Type getType() {
    return type;
  }

  @Nullable
  @Override
  public Schema getSchema() {
    return schema;
  }

  @Nullable
  @Override
  public TableId getBaseTableId() {
    return baseTableId;
  }

  @Nullable
  @Override
  public String getSnapshotTime() {
    return snapshotTime;
  }

  @Nullable
  @Override
  public TimePartitioning getTimePartitioning() {
    return timePartitioning;
  }

  @Nullable
  @Override
  public RangePartitioning getRangePartitioning() {
    return rangePartitioning;
  }

  @Nullable
  @Override
  public Clustering getClustering() {
    return clustering;
  }

  @Override
  public String toString() {
    return "SnapshotTableDefinition{"
        + "type=" + type + ", "
        + "schema=" + schema + ", "
        + "baseTableId=" + baseTableId + ", "
        + "snapshotTime=" + snapshotTime + ", "
        + "timePartitioning=" + timePartitioning + ", "
        + "rangePartitioning=" + rangePartitioning + ", "
        + "clustering=" + clustering
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SnapshotTableDefinition) {
      SnapshotTableDefinition that = (SnapshotTableDefinition) o;
      return this.type.equals(that.getType())
          && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema()))
          && (this.baseTableId == null ? that.getBaseTableId() == null : this.baseTableId.equals(that.getBaseTableId()))
          && (this.snapshotTime == null ? that.getSnapshotTime() == null : this.snapshotTime.equals(that.getSnapshotTime()))
          && (this.timePartitioning == null ? that.getTimePartitioning() == null : this.timePartitioning.equals(that.getTimePartitioning()))
          && (this.rangePartitioning == null ? that.getRangePartitioning() == null : this.rangePartitioning.equals(that.getRangePartitioning()))
          && (this.clustering == null ? that.getClustering() == null : this.clustering.equals(that.getClustering()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (schema == null) ? 0 : schema.hashCode();
    h$ *= 1000003;
    h$ ^= (baseTableId == null) ? 0 : baseTableId.hashCode();
    h$ *= 1000003;
    h$ ^= (snapshotTime == null) ? 0 : snapshotTime.hashCode();
    h$ *= 1000003;
    h$ ^= (timePartitioning == null) ? 0 : timePartitioning.hashCode();
    h$ *= 1000003;
    h$ ^= (rangePartitioning == null) ? 0 : rangePartitioning.hashCode();
    h$ *= 1000003;
    h$ ^= (clustering == null) ? 0 : clustering.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 2113445776046717526L;

  @Override
  public SnapshotTableDefinition.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends SnapshotTableDefinition.Builder {
    private TableDefinition.Type type;
    private Schema schema;
    private TableId baseTableId;
    private String snapshotTime;
    private TimePartitioning timePartitioning;
    private RangePartitioning rangePartitioning;
    private Clustering clustering;
    Builder() {
    }
    private Builder(SnapshotTableDefinition source) {
      this.type = source.getType();
      this.schema = source.getSchema();
      this.baseTableId = source.getBaseTableId();
      this.snapshotTime = source.getSnapshotTime();
      this.timePartitioning = source.getTimePartitioning();
      this.rangePartitioning = source.getRangePartitioning();
      this.clustering = source.getClustering();
    }
    @Override
    public SnapshotTableDefinition.Builder setType(TableDefinition.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public SnapshotTableDefinition.Builder setSchema(Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    public SnapshotTableDefinition.Builder setBaseTableId(TableId baseTableId) {
      this.baseTableId = baseTableId;
      return this;
    }
    @Override
    public SnapshotTableDefinition.Builder setSnapshotTime(String snapshotTime) {
      this.snapshotTime = snapshotTime;
      return this;
    }
    @Override
    public SnapshotTableDefinition.Builder setTimePartitioning(TimePartitioning timePartitioning) {
      this.timePartitioning = timePartitioning;
      return this;
    }
    @Override
    public SnapshotTableDefinition.Builder setRangePartitioning(RangePartitioning rangePartitioning) {
      this.rangePartitioning = rangePartitioning;
      return this;
    }
    @Override
    public SnapshotTableDefinition.Builder setClustering(Clustering clustering) {
      this.clustering = clustering;
      return this;
    }
    @Override
    public SnapshotTableDefinition build() {
      if (this.type == null) {
        String missing = " type";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SnapshotTableDefinition(
          this.type,
          this.schema,
          this.baseTableId,
          this.snapshotTime,
          this.timePartitioning,
          this.rangePartitioning,
          this.clustering);
    }
  }

}
