package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_DmlStats extends DmlStats {

  private final Long deletedRowCount;

  private final Long insertedRowCount;

  private final Long updatedRowCount;

  private AutoValue_DmlStats(
      @Nullable Long deletedRowCount,
      @Nullable Long insertedRowCount,
      @Nullable Long updatedRowCount) {
    this.deletedRowCount = deletedRowCount;
    this.insertedRowCount = insertedRowCount;
    this.updatedRowCount = updatedRowCount;
  }

  @Nullable
  @Override
  public Long getDeletedRowCount() {
    return deletedRowCount;
  }

  @Nullable
  @Override
  public Long getInsertedRowCount() {
    return insertedRowCount;
  }

  @Nullable
  @Override
  public Long getUpdatedRowCount() {
    return updatedRowCount;
  }

  @Override
  public String toString() {
    return "DmlStats{"
        + "deletedRowCount=" + deletedRowCount + ", "
        + "insertedRowCount=" + insertedRowCount + ", "
        + "updatedRowCount=" + updatedRowCount
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DmlStats) {
      DmlStats that = (DmlStats) o;
      return (this.deletedRowCount == null ? that.getDeletedRowCount() == null : this.deletedRowCount.equals(that.getDeletedRowCount()))
          && (this.insertedRowCount == null ? that.getInsertedRowCount() == null : this.insertedRowCount.equals(that.getInsertedRowCount()))
          && (this.updatedRowCount == null ? that.getUpdatedRowCount() == null : this.updatedRowCount.equals(that.getUpdatedRowCount()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (deletedRowCount == null) ? 0 : deletedRowCount.hashCode();
    h$ *= 1000003;
    h$ ^= (insertedRowCount == null) ? 0 : insertedRowCount.hashCode();
    h$ *= 1000003;
    h$ ^= (updatedRowCount == null) ? 0 : updatedRowCount.hashCode();
    return h$;
  }

  @Override
  public DmlStats.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends DmlStats.Builder {
    private Long deletedRowCount;
    private Long insertedRowCount;
    private Long updatedRowCount;
    Builder() {
    }
    private Builder(DmlStats source) {
      this.deletedRowCount = source.getDeletedRowCount();
      this.insertedRowCount = source.getInsertedRowCount();
      this.updatedRowCount = source.getUpdatedRowCount();
    }
    @Override
    public DmlStats.Builder setDeletedRowCount(Long deletedRowCount) {
      this.deletedRowCount = deletedRowCount;
      return this;
    }
    @Override
    public DmlStats.Builder setInsertedRowCount(Long insertedRowCount) {
      this.insertedRowCount = insertedRowCount;
      return this;
    }
    @Override
    public DmlStats.Builder setUpdatedRowCount(Long updatedRowCount) {
      this.updatedRowCount = updatedRowCount;
      return this;
    }
    @Override
    public DmlStats build() {
      return new AutoValue_DmlStats(
          this.deletedRowCount,
          this.insertedRowCount,
          this.updatedRowCount);
    }
  }

}
