/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.RoutineReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;

public final class RoutineId
implements Serializable {
    static final Function<RoutineReference, RoutineId> FROM_PB_FUNCTION = new Function<RoutineReference, RoutineId>(){

        public RoutineId apply(RoutineReference pb) {
            return RoutineId.fromPb(pb);
        }
    };
    static final Function<RoutineId, RoutineReference> TO_PB_FUNCTION = new Function<RoutineId, RoutineReference>(){

        public RoutineReference apply(RoutineId routineId) {
            return routineId.toPb();
        }
    };
    private final String project;
    private final String dataset;
    private final String routine;

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getRoutine() {
        return this.routine;
    }

    private RoutineId(String project, String dataset, String routine) {
        this.project = project;
        this.dataset = dataset;
        this.routine = routine;
    }

    public static RoutineId of(String project, String dataset, String routine) {
        return new RoutineId((String)Preconditions.checkNotNull((Object)project), (String)Preconditions.checkNotNull((Object)dataset), (String)Preconditions.checkNotNull((Object)routine));
    }

    public static RoutineId of(String dataset, String routine) {
        return new RoutineId(null, (String)Preconditions.checkNotNull((Object)dataset), (String)Preconditions.checkNotNull((Object)routine));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof RoutineId && Objects.equals(this.toPb(), ((RoutineId)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.project, this.dataset, this.routine);
    }

    public String toString() {
        return this.toPb().toString();
    }

    RoutineId setProjectId(String projectId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Provided projectId is null or empty");
        return RoutineId.of(projectId, this.getDataset(), this.getRoutine());
    }

    RoutineReference toPb() {
        return new RoutineReference().setProjectId(this.project).setDatasetId(this.dataset).setRoutineId(this.routine);
    }

    static RoutineId fromPb(RoutineReference routineRef) {
        return new RoutineId(routineRef.getProjectId(), routineRef.getDatasetId(), routineRef.getRoutineId());
    }
}

