/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class Dataset
extends DatasetInfo {
    private static final long serialVersionUID = -4272921483363065593L;
    private final BigQueryOptions options;
    private transient BigQuery bigquery;

    Dataset(BigQuery bigquery, DatasetInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.bigquery = (BigQuery)Preconditions.checkNotNull((Object)bigquery);
        this.options = (BigQueryOptions)bigquery.getOptions();
    }

    public boolean exists() {
        return this.bigquery.getDataset(this.getDatasetId(), BigQuery.DatasetOption.fields(new BigQuery.DatasetField[0])) != null;
    }

    public Dataset reload(BigQuery.DatasetOption ... options) {
        return this.bigquery.getDataset(this.getDatasetId().getDataset(), options);
    }

    public Dataset update(BigQuery.DatasetOption ... options) {
        return this.bigquery.update(this, options);
    }

    public boolean delete(BigQuery.DatasetDeleteOption ... options) {
        return this.bigquery.delete(this.getDatasetId(), options);
    }

    public Page<Table> list(BigQuery.TableListOption ... options) {
        return this.bigquery.listTables(this.getDatasetId(), options);
    }

    public Table get(String tableId, BigQuery.TableOption ... options) {
        return this.bigquery.getTable(TableId.of(this.getDatasetId().getDataset(), tableId), options);
    }

    public Table create(String tableId, TableDefinition definition, BigQuery.TableOption ... options) {
        TableInfo tableInfo = TableInfo.of(TableId.of(this.getDatasetId().getDataset(), tableId), definition);
        return this.bigquery.create(tableInfo, options);
    }

    public BigQuery getBigquery() {
        return this.bigquery;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Dataset.class)) {
            return false;
        }
        Dataset other = (Dataset)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bigquery = (BigQuery)this.options.getService();
    }

    static Dataset fromPb(BigQuery bigquery, com.google.api.services.bigquery.model.Dataset datasetPb) {
        return new Dataset(bigquery, new DatasetInfo.BuilderImpl(datasetPb));
    }

    public static final class Builder
    extends DatasetInfo.Builder {
        private final BigQuery bigquery;
        private final DatasetInfo.BuilderImpl infoBuilder;

        Builder(BigQuery bigquery, DatasetId datasetId) {
            this.bigquery = bigquery;
            this.infoBuilder = new DatasetInfo.BuilderImpl();
            this.infoBuilder.setDatasetId(datasetId);
        }

        Builder(Dataset dataset) {
            this.bigquery = dataset.bigquery;
            this.infoBuilder = new DatasetInfo.BuilderImpl(dataset);
        }

        @Override
        public Builder setDatasetId(DatasetId datasetId) {
            this.infoBuilder.setDatasetId(datasetId);
            return this;
        }

        @Override
        public Builder setAcl(List<Acl> acl) {
            this.infoBuilder.setAcl(acl);
            return this;
        }

        @Override
        Builder setCreationTime(Long creationTime) {
            this.infoBuilder.setCreationTime(creationTime);
            return this;
        }

        @Override
        public Builder setDefaultTableLifetime(Long defaultTableLifetime) {
            this.infoBuilder.setDefaultTableLifetime(defaultTableLifetime);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        public Builder setFriendlyName(String friendlyName) {
            this.infoBuilder.setFriendlyName(friendlyName);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        Builder setLastModified(Long lastModified) {
            this.infoBuilder.setLastModified(lastModified);
            return this;
        }

        @Override
        public Builder setLocation(String location) {
            this.infoBuilder.setLocation(location);
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.infoBuilder.setSelfLink(selfLink);
            return this;
        }

        @Override
        public Dataset build() {
            return new Dataset(this.bigquery, this.infoBuilder);
        }
    }
}

