/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateIndexEndpointOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateIndexEndpointRequest;
import com.google.cloud.aiplatform.v1.DeleteIndexEndpointRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployIndexOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployIndexRequest;
import com.google.cloud.aiplatform.v1.DeployIndexResponse;
import com.google.cloud.aiplatform.v1.DeployedIndex;
import com.google.cloud.aiplatform.v1.GetIndexEndpointRequest;
import com.google.cloud.aiplatform.v1.IndexEndpoint;
import com.google.cloud.aiplatform.v1.IndexEndpointName;
import com.google.cloud.aiplatform.v1.IndexEndpointServiceSettings;
import com.google.cloud.aiplatform.v1.ListIndexEndpointsRequest;
import com.google.cloud.aiplatform.v1.ListIndexEndpointsResponse;
import com.google.cloud.aiplatform.v1.LocationName;
import com.google.cloud.aiplatform.v1.MutateDeployedIndexOperationMetadata;
import com.google.cloud.aiplatform.v1.MutateDeployedIndexRequest;
import com.google.cloud.aiplatform.v1.MutateDeployedIndexResponse;
import com.google.cloud.aiplatform.v1.UndeployIndexOperationMetadata;
import com.google.cloud.aiplatform.v1.UndeployIndexRequest;
import com.google.cloud.aiplatform.v1.UndeployIndexResponse;
import com.google.cloud.aiplatform.v1.UpdateIndexEndpointRequest;
import com.google.cloud.aiplatform.v1.stub.IndexEndpointServiceStub;
import com.google.cloud.aiplatform.v1.stub.IndexEndpointServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class IndexEndpointServiceClient
implements BackgroundResource {
    private final IndexEndpointServiceSettings settings;
    private final IndexEndpointServiceStub stub;
    private final OperationsClient operationsClient;

    public static final IndexEndpointServiceClient create() throws IOException {
        return IndexEndpointServiceClient.create(IndexEndpointServiceSettings.newBuilder().build());
    }

    public static final IndexEndpointServiceClient create(IndexEndpointServiceSettings settings) throws IOException {
        return new IndexEndpointServiceClient(settings);
    }

    public static final IndexEndpointServiceClient create(IndexEndpointServiceStub stub) {
        return new IndexEndpointServiceClient(stub);
    }

    protected IndexEndpointServiceClient(IndexEndpointServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IndexEndpointServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected IndexEndpointServiceClient(IndexEndpointServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final IndexEndpointServiceSettings getSettings() {
        return this.settings;
    }

    public IndexEndpointServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointAsync(LocationName parent, IndexEndpoint indexEndpoint) {
        CreateIndexEndpointRequest request = CreateIndexEndpointRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIndexEndpoint(indexEndpoint).build();
        return this.createIndexEndpointAsync(request);
    }

    public final OperationFuture<IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointAsync(String parent, IndexEndpoint indexEndpoint) {
        CreateIndexEndpointRequest request = CreateIndexEndpointRequest.newBuilder().setParent(parent).setIndexEndpoint(indexEndpoint).build();
        return this.createIndexEndpointAsync(request);
    }

    public final OperationFuture<IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointAsync(CreateIndexEndpointRequest request) {
        return this.createIndexEndpointOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateIndexEndpointRequest, IndexEndpoint, CreateIndexEndpointOperationMetadata> createIndexEndpointOperationCallable() {
        return this.stub.createIndexEndpointOperationCallable();
    }

    public final UnaryCallable<CreateIndexEndpointRequest, Operation> createIndexEndpointCallable() {
        return this.stub.createIndexEndpointCallable();
    }

    public final IndexEndpoint getIndexEndpoint(IndexEndpointName name) {
        GetIndexEndpointRequest request = GetIndexEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIndexEndpoint(request);
    }

    public final IndexEndpoint getIndexEndpoint(String name) {
        GetIndexEndpointRequest request = GetIndexEndpointRequest.newBuilder().setName(name).build();
        return this.getIndexEndpoint(request);
    }

    public final IndexEndpoint getIndexEndpoint(GetIndexEndpointRequest request) {
        return (IndexEndpoint)this.getIndexEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<GetIndexEndpointRequest, IndexEndpoint> getIndexEndpointCallable() {
        return this.stub.getIndexEndpointCallable();
    }

    public final ListIndexEndpointsPagedResponse listIndexEndpoints(LocationName parent) {
        ListIndexEndpointsRequest request = ListIndexEndpointsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIndexEndpoints(request);
    }

    public final ListIndexEndpointsPagedResponse listIndexEndpoints(String parent) {
        ListIndexEndpointsRequest request = ListIndexEndpointsRequest.newBuilder().setParent(parent).build();
        return this.listIndexEndpoints(request);
    }

    public final ListIndexEndpointsPagedResponse listIndexEndpoints(ListIndexEndpointsRequest request) {
        return (ListIndexEndpointsPagedResponse)((Object)this.listIndexEndpointsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIndexEndpointsRequest, ListIndexEndpointsPagedResponse> listIndexEndpointsPagedCallable() {
        return this.stub.listIndexEndpointsPagedCallable();
    }

    public final UnaryCallable<ListIndexEndpointsRequest, ListIndexEndpointsResponse> listIndexEndpointsCallable() {
        return this.stub.listIndexEndpointsCallable();
    }

    public final IndexEndpoint updateIndexEndpoint(IndexEndpoint indexEndpoint, FieldMask updateMask) {
        UpdateIndexEndpointRequest request = UpdateIndexEndpointRequest.newBuilder().setIndexEndpoint(indexEndpoint).setUpdateMask(updateMask).build();
        return this.updateIndexEndpoint(request);
    }

    public final IndexEndpoint updateIndexEndpoint(UpdateIndexEndpointRequest request) {
        return (IndexEndpoint)this.updateIndexEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateIndexEndpointRequest, IndexEndpoint> updateIndexEndpointCallable() {
        return this.stub.updateIndexEndpointCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteIndexEndpointAsync(IndexEndpointName name) {
        DeleteIndexEndpointRequest request = DeleteIndexEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteIndexEndpointAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteIndexEndpointAsync(String name) {
        DeleteIndexEndpointRequest request = DeleteIndexEndpointRequest.newBuilder().setName(name).build();
        return this.deleteIndexEndpointAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteIndexEndpointAsync(DeleteIndexEndpointRequest request) {
        return this.deleteIndexEndpointOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteIndexEndpointRequest, Empty, DeleteOperationMetadata> deleteIndexEndpointOperationCallable() {
        return this.stub.deleteIndexEndpointOperationCallable();
    }

    public final UnaryCallable<DeleteIndexEndpointRequest, Operation> deleteIndexEndpointCallable() {
        return this.stub.deleteIndexEndpointCallable();
    }

    public final OperationFuture<DeployIndexResponse, DeployIndexOperationMetadata> deployIndexAsync(IndexEndpointName indexEndpoint, DeployedIndex deployedIndex) {
        DeployIndexRequest request = DeployIndexRequest.newBuilder().setIndexEndpoint(indexEndpoint == null ? null : indexEndpoint.toString()).setDeployedIndex(deployedIndex).build();
        return this.deployIndexAsync(request);
    }

    public final OperationFuture<DeployIndexResponse, DeployIndexOperationMetadata> deployIndexAsync(String indexEndpoint, DeployedIndex deployedIndex) {
        DeployIndexRequest request = DeployIndexRequest.newBuilder().setIndexEndpoint(indexEndpoint).setDeployedIndex(deployedIndex).build();
        return this.deployIndexAsync(request);
    }

    public final OperationFuture<DeployIndexResponse, DeployIndexOperationMetadata> deployIndexAsync(DeployIndexRequest request) {
        return this.deployIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeployIndexRequest, DeployIndexResponse, DeployIndexOperationMetadata> deployIndexOperationCallable() {
        return this.stub.deployIndexOperationCallable();
    }

    public final UnaryCallable<DeployIndexRequest, Operation> deployIndexCallable() {
        return this.stub.deployIndexCallable();
    }

    public final OperationFuture<UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexAsync(IndexEndpointName indexEndpoint, String deployedIndexId) {
        UndeployIndexRequest request = UndeployIndexRequest.newBuilder().setIndexEndpoint(indexEndpoint == null ? null : indexEndpoint.toString()).setDeployedIndexId(deployedIndexId).build();
        return this.undeployIndexAsync(request);
    }

    public final OperationFuture<UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexAsync(String indexEndpoint, String deployedIndexId) {
        UndeployIndexRequest request = UndeployIndexRequest.newBuilder().setIndexEndpoint(indexEndpoint).setDeployedIndexId(deployedIndexId).build();
        return this.undeployIndexAsync(request);
    }

    public final OperationFuture<UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexAsync(UndeployIndexRequest request) {
        return this.undeployIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeployIndexRequest, UndeployIndexResponse, UndeployIndexOperationMetadata> undeployIndexOperationCallable() {
        return this.stub.undeployIndexOperationCallable();
    }

    public final UnaryCallable<UndeployIndexRequest, Operation> undeployIndexCallable() {
        return this.stub.undeployIndexCallable();
    }

    public final OperationFuture<MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexAsync(IndexEndpointName indexEndpoint, DeployedIndex deployedIndex) {
        MutateDeployedIndexRequest request = MutateDeployedIndexRequest.newBuilder().setIndexEndpoint(indexEndpoint == null ? null : indexEndpoint.toString()).setDeployedIndex(deployedIndex).build();
        return this.mutateDeployedIndexAsync(request);
    }

    public final OperationFuture<MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexAsync(String indexEndpoint, DeployedIndex deployedIndex) {
        MutateDeployedIndexRequest request = MutateDeployedIndexRequest.newBuilder().setIndexEndpoint(indexEndpoint).setDeployedIndex(deployedIndex).build();
        return this.mutateDeployedIndexAsync(request);
    }

    public final OperationFuture<MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexAsync(MutateDeployedIndexRequest request) {
        return this.mutateDeployedIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MutateDeployedIndexRequest, MutateDeployedIndexResponse, MutateDeployedIndexOperationMetadata> mutateDeployedIndexOperationCallable() {
        return this.stub.mutateDeployedIndexOperationCallable();
    }

    public final UnaryCallable<MutateDeployedIndexRequest, Operation> mutateDeployedIndexCallable() {
        return this.stub.mutateDeployedIndexCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListIndexEndpointsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint, ListIndexEndpointsPage, ListIndexEndpointsFixedSizeCollection> {
        private ListIndexEndpointsFixedSizeCollection(List<ListIndexEndpointsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIndexEndpointsFixedSizeCollection createEmptyCollection() {
            return new ListIndexEndpointsFixedSizeCollection(null, 0);
        }

        protected ListIndexEndpointsFixedSizeCollection createCollection(List<ListIndexEndpointsPage> pages, int collectionSize) {
            return new ListIndexEndpointsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIndexEndpointsPage
    extends AbstractPage<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint, ListIndexEndpointsPage> {
        private ListIndexEndpointsPage(PageContext<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint> context, ListIndexEndpointsResponse response) {
            super(context, (Object)response);
        }

        private static ListIndexEndpointsPage createEmptyPage() {
            return new ListIndexEndpointsPage(null, null);
        }

        protected ListIndexEndpointsPage createPage(PageContext<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint> context, ListIndexEndpointsResponse response) {
            return new ListIndexEndpointsPage(context, response);
        }

        public ApiFuture<ListIndexEndpointsPage> createPageAsync(PageContext<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint> context, ApiFuture<ListIndexEndpointsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIndexEndpointsPagedResponse
    extends AbstractPagedListResponse<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint, ListIndexEndpointsPage, ListIndexEndpointsFixedSizeCollection> {
        public static ApiFuture<ListIndexEndpointsPagedResponse> createAsync(PageContext<ListIndexEndpointsRequest, ListIndexEndpointsResponse, IndexEndpoint> context, ApiFuture<ListIndexEndpointsResponse> futureResponse) {
            ApiFuture<ListIndexEndpointsPage> futurePage = ListIndexEndpointsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIndexEndpointsPagedResponse((ListIndexEndpointsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIndexEndpointsPagedResponse(ListIndexEndpointsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIndexEndpointsFixedSizeCollection.createEmptyCollection());
        }
    }
}

