/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateMemoryOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateMemoryRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteMemoryOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteMemoryRequest;
import com.google.cloud.aiplatform.v1beta1.GenerateMemoriesOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest;
import com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse;
import com.google.cloud.aiplatform.v1beta1.GetMemoryRequest;
import com.google.cloud.aiplatform.v1beta1.ListMemoriesRequest;
import com.google.cloud.aiplatform.v1beta1.ListMemoriesResponse;
import com.google.cloud.aiplatform.v1beta1.Memory;
import com.google.cloud.aiplatform.v1beta1.MemoryBankServiceSettings;
import com.google.cloud.aiplatform.v1beta1.MemoryName;
import com.google.cloud.aiplatform.v1beta1.ReasoningEngineName;
import com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest;
import com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateMemoryOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateMemoryRequest;
import com.google.cloud.aiplatform.v1beta1.stub.MemoryBankServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.MemoryBankServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MemoryBankServiceClient
implements BackgroundResource {
    private final MemoryBankServiceSettings settings;
    private final MemoryBankServiceStub stub;
    private final OperationsClient operationsClient;

    public static final MemoryBankServiceClient create() throws IOException {
        return MemoryBankServiceClient.create(MemoryBankServiceSettings.newBuilder().build());
    }

    public static final MemoryBankServiceClient create(MemoryBankServiceSettings settings) throws IOException {
        return new MemoryBankServiceClient(settings);
    }

    public static final MemoryBankServiceClient create(MemoryBankServiceStub stub) {
        return new MemoryBankServiceClient(stub);
    }

    protected MemoryBankServiceClient(MemoryBankServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MemoryBankServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected MemoryBankServiceClient(MemoryBankServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final MemoryBankServiceSettings getSettings() {
        return this.settings;
    }

    public MemoryBankServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Memory, CreateMemoryOperationMetadata> createMemoryAsync(CreateMemoryRequest request) {
        return this.createMemoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMemoryRequest, Memory, CreateMemoryOperationMetadata> createMemoryOperationCallable() {
        return this.stub.createMemoryOperationCallable();
    }

    public final UnaryCallable<CreateMemoryRequest, Operation> createMemoryCallable() {
        return this.stub.createMemoryCallable();
    }

    public final Memory getMemory(MemoryName name) {
        GetMemoryRequest request = GetMemoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMemory(request);
    }

    public final Memory getMemory(String name) {
        GetMemoryRequest request = GetMemoryRequest.newBuilder().setName(name).build();
        return this.getMemory(request);
    }

    public final Memory getMemory(GetMemoryRequest request) {
        return (Memory)this.getMemoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetMemoryRequest, Memory> getMemoryCallable() {
        return this.stub.getMemoryCallable();
    }

    public final OperationFuture<Memory, UpdateMemoryOperationMetadata> updateMemoryAsync(Memory memory, FieldMask updateMask) {
        UpdateMemoryRequest request = UpdateMemoryRequest.newBuilder().setMemory(memory).setUpdateMask(updateMask).build();
        return this.updateMemoryAsync(request);
    }

    public final OperationFuture<Memory, UpdateMemoryOperationMetadata> updateMemoryAsync(UpdateMemoryRequest request) {
        return this.updateMemoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMemoryRequest, Memory, UpdateMemoryOperationMetadata> updateMemoryOperationCallable() {
        return this.stub.updateMemoryOperationCallable();
    }

    public final UnaryCallable<UpdateMemoryRequest, Operation> updateMemoryCallable() {
        return this.stub.updateMemoryCallable();
    }

    public final ListMemoriesPagedResponse listMemories(ReasoningEngineName parent) {
        ListMemoriesRequest request = ListMemoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMemories(request);
    }

    public final ListMemoriesPagedResponse listMemories(String parent) {
        ListMemoriesRequest request = ListMemoriesRequest.newBuilder().setParent(parent).build();
        return this.listMemories(request);
    }

    public final ListMemoriesPagedResponse listMemories(ListMemoriesRequest request) {
        return (ListMemoriesPagedResponse)((Object)this.listMemoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMemoriesRequest, ListMemoriesPagedResponse> listMemoriesPagedCallable() {
        return this.stub.listMemoriesPagedCallable();
    }

    public final UnaryCallable<ListMemoriesRequest, ListMemoriesResponse> listMemoriesCallable() {
        return this.stub.listMemoriesCallable();
    }

    public final OperationFuture<Empty, DeleteMemoryOperationMetadata> deleteMemoryAsync(MemoryName name) {
        DeleteMemoryRequest request = DeleteMemoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMemoryAsync(request);
    }

    public final OperationFuture<Empty, DeleteMemoryOperationMetadata> deleteMemoryAsync(String name) {
        DeleteMemoryRequest request = DeleteMemoryRequest.newBuilder().setName(name).build();
        return this.deleteMemoryAsync(request);
    }

    public final OperationFuture<Empty, DeleteMemoryOperationMetadata> deleteMemoryAsync(DeleteMemoryRequest request) {
        return this.deleteMemoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMemoryRequest, Empty, DeleteMemoryOperationMetadata> deleteMemoryOperationCallable() {
        return this.stub.deleteMemoryOperationCallable();
    }

    public final UnaryCallable<DeleteMemoryRequest, Operation> deleteMemoryCallable() {
        return this.stub.deleteMemoryCallable();
    }

    public final OperationFuture<GenerateMemoriesResponse, GenerateMemoriesOperationMetadata> generateMemoriesAsync(ReasoningEngineName parent) {
        GenerateMemoriesRequest request = GenerateMemoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.generateMemoriesAsync(request);
    }

    public final OperationFuture<GenerateMemoriesResponse, GenerateMemoriesOperationMetadata> generateMemoriesAsync(String parent) {
        GenerateMemoriesRequest request = GenerateMemoriesRequest.newBuilder().setParent(parent).build();
        return this.generateMemoriesAsync(request);
    }

    public final OperationFuture<GenerateMemoriesResponse, GenerateMemoriesOperationMetadata> generateMemoriesAsync(GenerateMemoriesRequest request) {
        return this.generateMemoriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<GenerateMemoriesRequest, GenerateMemoriesResponse, GenerateMemoriesOperationMetadata> generateMemoriesOperationCallable() {
        return this.stub.generateMemoriesOperationCallable();
    }

    public final UnaryCallable<GenerateMemoriesRequest, Operation> generateMemoriesCallable() {
        return this.stub.generateMemoriesCallable();
    }

    public final RetrieveMemoriesResponse retrieveMemories(ReasoningEngineName parent) {
        RetrieveMemoriesRequest request = RetrieveMemoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.retrieveMemories(request);
    }

    public final RetrieveMemoriesResponse retrieveMemories(String parent) {
        RetrieveMemoriesRequest request = RetrieveMemoriesRequest.newBuilder().setParent(parent).build();
        return this.retrieveMemories(request);
    }

    public final RetrieveMemoriesResponse retrieveMemories(RetrieveMemoriesRequest request) {
        return (RetrieveMemoriesResponse)this.retrieveMemoriesCallable().call((Object)request);
    }

    public final UnaryCallable<RetrieveMemoriesRequest, RetrieveMemoriesResponse> retrieveMemoriesCallable() {
        return this.stub.retrieveMemoriesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMemoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMemoriesRequest, ListMemoriesResponse, Memory, ListMemoriesPage, ListMemoriesFixedSizeCollection> {
        private ListMemoriesFixedSizeCollection(List<ListMemoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMemoriesFixedSizeCollection createEmptyCollection() {
            return new ListMemoriesFixedSizeCollection(null, 0);
        }

        protected ListMemoriesFixedSizeCollection createCollection(List<ListMemoriesPage> pages, int collectionSize) {
            return new ListMemoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMemoriesPage
    extends AbstractPage<ListMemoriesRequest, ListMemoriesResponse, Memory, ListMemoriesPage> {
        private ListMemoriesPage(PageContext<ListMemoriesRequest, ListMemoriesResponse, Memory> context, ListMemoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListMemoriesPage createEmptyPage() {
            return new ListMemoriesPage(null, null);
        }

        protected ListMemoriesPage createPage(PageContext<ListMemoriesRequest, ListMemoriesResponse, Memory> context, ListMemoriesResponse response) {
            return new ListMemoriesPage(context, response);
        }

        public ApiFuture<ListMemoriesPage> createPageAsync(PageContext<ListMemoriesRequest, ListMemoriesResponse, Memory> context, ApiFuture<ListMemoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMemoriesPagedResponse
    extends AbstractPagedListResponse<ListMemoriesRequest, ListMemoriesResponse, Memory, ListMemoriesPage, ListMemoriesFixedSizeCollection> {
        public static ApiFuture<ListMemoriesPagedResponse> createAsync(PageContext<ListMemoriesRequest, ListMemoriesResponse, Memory> context, ApiFuture<ListMemoriesResponse> futureResponse) {
            ApiFuture<ListMemoriesPage> futurePage = ListMemoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMemoriesPagedResponse((ListMemoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMemoriesPagedResponse(ListMemoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMemoriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

