/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CachedContent;
import com.google.cloud.aiplatform.v1.CachedContentName;
import com.google.cloud.aiplatform.v1.CreateCachedContentRequest;
import com.google.cloud.aiplatform.v1.DeleteCachedContentRequest;
import com.google.cloud.aiplatform.v1.GenAiCacheServiceSettings;
import com.google.cloud.aiplatform.v1.GetCachedContentRequest;
import com.google.cloud.aiplatform.v1.ListCachedContentsRequest;
import com.google.cloud.aiplatform.v1.ListCachedContentsResponse;
import com.google.cloud.aiplatform.v1.LocationName;
import com.google.cloud.aiplatform.v1.UpdateCachedContentRequest;
import com.google.cloud.aiplatform.v1.stub.GenAiCacheServiceStub;
import com.google.cloud.aiplatform.v1.stub.GenAiCacheServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GenAiCacheServiceClient
implements BackgroundResource {
    private final GenAiCacheServiceSettings settings;
    private final GenAiCacheServiceStub stub;

    public static final GenAiCacheServiceClient create() throws IOException {
        return GenAiCacheServiceClient.create(GenAiCacheServiceSettings.newBuilder().build());
    }

    public static final GenAiCacheServiceClient create(GenAiCacheServiceSettings settings) throws IOException {
        return new GenAiCacheServiceClient(settings);
    }

    public static final GenAiCacheServiceClient create(GenAiCacheServiceStub stub) {
        return new GenAiCacheServiceClient(stub);
    }

    protected GenAiCacheServiceClient(GenAiCacheServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GenAiCacheServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected GenAiCacheServiceClient(GenAiCacheServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GenAiCacheServiceSettings getSettings() {
        return this.settings;
    }

    public GenAiCacheServiceStub getStub() {
        return this.stub;
    }

    public final CachedContent createCachedContent(LocationName parent, CachedContent cachedContent) {
        CreateCachedContentRequest request = CreateCachedContentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCachedContent(cachedContent).build();
        return this.createCachedContent(request);
    }

    public final CachedContent createCachedContent(String parent, CachedContent cachedContent) {
        CreateCachedContentRequest request = CreateCachedContentRequest.newBuilder().setParent(parent).setCachedContent(cachedContent).build();
        return this.createCachedContent(request);
    }

    public final CachedContent createCachedContent(CreateCachedContentRequest request) {
        return (CachedContent)this.createCachedContentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCachedContentRequest, CachedContent> createCachedContentCallable() {
        return this.stub.createCachedContentCallable();
    }

    public final CachedContent getCachedContent(CachedContentName name) {
        GetCachedContentRequest request = GetCachedContentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCachedContent(request);
    }

    public final CachedContent getCachedContent(String name) {
        GetCachedContentRequest request = GetCachedContentRequest.newBuilder().setName(name).build();
        return this.getCachedContent(request);
    }

    public final CachedContent getCachedContent(GetCachedContentRequest request) {
        return (CachedContent)this.getCachedContentCallable().call((Object)request);
    }

    public final UnaryCallable<GetCachedContentRequest, CachedContent> getCachedContentCallable() {
        return this.stub.getCachedContentCallable();
    }

    public final CachedContent updateCachedContent(CachedContent cachedContent, FieldMask updateMask) {
        UpdateCachedContentRequest request = UpdateCachedContentRequest.newBuilder().setCachedContent(cachedContent).setUpdateMask(updateMask).build();
        return this.updateCachedContent(request);
    }

    public final CachedContent updateCachedContent(UpdateCachedContentRequest request) {
        return (CachedContent)this.updateCachedContentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCachedContentRequest, CachedContent> updateCachedContentCallable() {
        return this.stub.updateCachedContentCallable();
    }

    public final void deleteCachedContent(CachedContentName name) {
        DeleteCachedContentRequest request = DeleteCachedContentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCachedContent(request);
    }

    public final void deleteCachedContent(String name) {
        DeleteCachedContentRequest request = DeleteCachedContentRequest.newBuilder().setName(name).build();
        this.deleteCachedContent(request);
    }

    public final void deleteCachedContent(DeleteCachedContentRequest request) {
        this.deleteCachedContentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCachedContentRequest, Empty> deleteCachedContentCallable() {
        return this.stub.deleteCachedContentCallable();
    }

    public final ListCachedContentsPagedResponse listCachedContents(LocationName parent) {
        ListCachedContentsRequest request = ListCachedContentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCachedContents(request);
    }

    public final ListCachedContentsPagedResponse listCachedContents(String parent) {
        ListCachedContentsRequest request = ListCachedContentsRequest.newBuilder().setParent(parent).build();
        return this.listCachedContents(request);
    }

    public final ListCachedContentsPagedResponse listCachedContents(ListCachedContentsRequest request) {
        return (ListCachedContentsPagedResponse)((Object)this.listCachedContentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCachedContentsRequest, ListCachedContentsPagedResponse> listCachedContentsPagedCallable() {
        return this.stub.listCachedContentsPagedCallable();
    }

    public final UnaryCallable<ListCachedContentsRequest, ListCachedContentsResponse> listCachedContentsCallable() {
        return this.stub.listCachedContentsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCachedContentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCachedContentsRequest, ListCachedContentsResponse, CachedContent, ListCachedContentsPage, ListCachedContentsFixedSizeCollection> {
        private ListCachedContentsFixedSizeCollection(List<ListCachedContentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCachedContentsFixedSizeCollection createEmptyCollection() {
            return new ListCachedContentsFixedSizeCollection(null, 0);
        }

        protected ListCachedContentsFixedSizeCollection createCollection(List<ListCachedContentsPage> pages, int collectionSize) {
            return new ListCachedContentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCachedContentsPage
    extends AbstractPage<ListCachedContentsRequest, ListCachedContentsResponse, CachedContent, ListCachedContentsPage> {
        private ListCachedContentsPage(PageContext<ListCachedContentsRequest, ListCachedContentsResponse, CachedContent> context, ListCachedContentsResponse response) {
            super(context, (Object)response);
        }

        private static ListCachedContentsPage createEmptyPage() {
            return new ListCachedContentsPage(null, null);
        }

        protected ListCachedContentsPage createPage(PageContext<ListCachedContentsRequest, ListCachedContentsResponse, CachedContent> context, ListCachedContentsResponse response) {
            return new ListCachedContentsPage(context, response);
        }

        public ApiFuture<ListCachedContentsPage> createPageAsync(PageContext<ListCachedContentsRequest, ListCachedContentsResponse, CachedContent> context, ApiFuture<ListCachedContentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCachedContentsPagedResponse
    extends AbstractPagedListResponse<ListCachedContentsRequest, ListCachedContentsResponse, CachedContent, ListCachedContentsPage, ListCachedContentsFixedSizeCollection> {
        public static ApiFuture<ListCachedContentsPagedResponse> createAsync(PageContext<ListCachedContentsRequest, ListCachedContentsResponse, CachedContent> context, ApiFuture<ListCachedContentsResponse> futureResponse) {
            ApiFuture<ListCachedContentsPage> futurePage = ListCachedContentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCachedContentsPagedResponse((ListCachedContentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCachedContentsPagedResponse(ListCachedContentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCachedContentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

