/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CancelTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.GenAiTuningServiceSettings;
import com.google.cloud.aiplatform.v1beta1.GetTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.ListTuningJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListTuningJobsResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.TuningJob;
import com.google.cloud.aiplatform.v1beta1.TuningJobName;
import com.google.cloud.aiplatform.v1beta1.stub.GenAiTuningServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.GenAiTuningServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GenAiTuningServiceClient
implements BackgroundResource {
    private final GenAiTuningServiceSettings settings;
    private final GenAiTuningServiceStub stub;

    public static final GenAiTuningServiceClient create() throws IOException {
        return GenAiTuningServiceClient.create(GenAiTuningServiceSettings.newBuilder().build());
    }

    public static final GenAiTuningServiceClient create(GenAiTuningServiceSettings settings) throws IOException {
        return new GenAiTuningServiceClient(settings);
    }

    public static final GenAiTuningServiceClient create(GenAiTuningServiceStub stub) {
        return new GenAiTuningServiceClient(stub);
    }

    protected GenAiTuningServiceClient(GenAiTuningServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GenAiTuningServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected GenAiTuningServiceClient(GenAiTuningServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GenAiTuningServiceSettings getSettings() {
        return this.settings;
    }

    public GenAiTuningServiceStub getStub() {
        return this.stub;
    }

    public final TuningJob createTuningJob(LocationName parent, TuningJob tuningJob) {
        CreateTuningJobRequest request = CreateTuningJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTuningJob(tuningJob).build();
        return this.createTuningJob(request);
    }

    public final TuningJob createTuningJob(String parent, TuningJob tuningJob) {
        CreateTuningJobRequest request = CreateTuningJobRequest.newBuilder().setParent(parent).setTuningJob(tuningJob).build();
        return this.createTuningJob(request);
    }

    public final TuningJob createTuningJob(CreateTuningJobRequest request) {
        return (TuningJob)this.createTuningJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTuningJobRequest, TuningJob> createTuningJobCallable() {
        return this.stub.createTuningJobCallable();
    }

    public final TuningJob getTuningJob(TuningJobName name) {
        GetTuningJobRequest request = GetTuningJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTuningJob(request);
    }

    public final TuningJob getTuningJob(String name) {
        GetTuningJobRequest request = GetTuningJobRequest.newBuilder().setName(name).build();
        return this.getTuningJob(request);
    }

    public final TuningJob getTuningJob(GetTuningJobRequest request) {
        return (TuningJob)this.getTuningJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetTuningJobRequest, TuningJob> getTuningJobCallable() {
        return this.stub.getTuningJobCallable();
    }

    public final ListTuningJobsPagedResponse listTuningJobs(LocationName parent) {
        ListTuningJobsRequest request = ListTuningJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTuningJobs(request);
    }

    public final ListTuningJobsPagedResponse listTuningJobs(String parent) {
        ListTuningJobsRequest request = ListTuningJobsRequest.newBuilder().setParent(parent).build();
        return this.listTuningJobs(request);
    }

    public final ListTuningJobsPagedResponse listTuningJobs(ListTuningJobsRequest request) {
        return (ListTuningJobsPagedResponse)((Object)this.listTuningJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTuningJobsRequest, ListTuningJobsPagedResponse> listTuningJobsPagedCallable() {
        return this.stub.listTuningJobsPagedCallable();
    }

    public final UnaryCallable<ListTuningJobsRequest, ListTuningJobsResponse> listTuningJobsCallable() {
        return this.stub.listTuningJobsCallable();
    }

    public final void cancelTuningJob(TuningJobName name) {
        CancelTuningJobRequest request = CancelTuningJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelTuningJob(request);
    }

    public final void cancelTuningJob(String name) {
        CancelTuningJobRequest request = CancelTuningJobRequest.newBuilder().setName(name).build();
        this.cancelTuningJob(request);
    }

    public final void cancelTuningJob(CancelTuningJobRequest request) {
        this.cancelTuningJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelTuningJobRequest, Empty> cancelTuningJobCallable() {
        return this.stub.cancelTuningJobCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTuningJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob, ListTuningJobsPage, ListTuningJobsFixedSizeCollection> {
        private ListTuningJobsFixedSizeCollection(List<ListTuningJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTuningJobsFixedSizeCollection createEmptyCollection() {
            return new ListTuningJobsFixedSizeCollection(null, 0);
        }

        protected ListTuningJobsFixedSizeCollection createCollection(List<ListTuningJobsPage> pages, int collectionSize) {
            return new ListTuningJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTuningJobsPage
    extends AbstractPage<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob, ListTuningJobsPage> {
        private ListTuningJobsPage(PageContext<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob> context, ListTuningJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListTuningJobsPage createEmptyPage() {
            return new ListTuningJobsPage(null, null);
        }

        protected ListTuningJobsPage createPage(PageContext<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob> context, ListTuningJobsResponse response) {
            return new ListTuningJobsPage(context, response);
        }

        public ApiFuture<ListTuningJobsPage> createPageAsync(PageContext<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob> context, ApiFuture<ListTuningJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTuningJobsPagedResponse
    extends AbstractPagedListResponse<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob, ListTuningJobsPage, ListTuningJobsFixedSizeCollection> {
        public static ApiFuture<ListTuningJobsPagedResponse> createAsync(PageContext<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob> context, ApiFuture<ListTuningJobsResponse> futureResponse) {
            ApiFuture<ListTuningJobsPage> futurePage = ListTuningJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTuningJobsPagedResponse((ListTuningJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTuningJobsPagedResponse(ListTuningJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTuningJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

