/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.plugin;

import com.google.cloud.functions.invoker.runner.Invoker;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresDependencyCollection=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.COMPILE)
public class RunFunction
extends AbstractMojo {
    @Parameter(property="run.functionTarget")
    private String functionTarget;
    @Parameter(property="run.port", defaultValue="8080")
    private Integer port;
    @Parameter(defaultValue="${project.runtimeClasspathElements}", readonly=true, required=true)
    private List<String> runtimePath;

    public void execute() throws MojoExecutionException {
        String classpath = String.join((CharSequence)File.pathSeparator, this.runtimePath);
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("--classpath", classpath));
        if (this.functionTarget != null) {
            args.addAll(Arrays.asList("--target", this.functionTarget));
        }
        if (this.port != null) {
            args.addAll(Arrays.asList("--port", String.valueOf(this.port)));
        }
        try {
            this.getLog().info((CharSequence)("Calling Invoker with " + args));
            Invoker.main((String[])args.toArray(new String[0]));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Could not invoke function: " + e), (Throwable)e);
            throw new MojoExecutionException("Could not invoke function", e);
        }
    }
}

