/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.plugin;

import com.google.cloud.tools.appengine.operations.CloudSdk;
import com.google.cloud.tools.appengine.operations.Gcloud;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkNotFoundException;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkOutOfDateException;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkVersionFileException;
import com.google.cloud.tools.appengine.operations.cloudsdk.process.ProcessHandlerException;
import com.google.cloud.tools.managedcloudsdk.BadCloudSdkVersionException;
import com.google.cloud.tools.managedcloudsdk.ManagedCloudSdk;
import com.google.cloud.tools.managedcloudsdk.UnsupportedOsException;
import com.google.cloud.tools.managedcloudsdk.Version;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkChecker;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkDownloader;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkMojo;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.NONE, requiresDependencyCollection=ResolutionScope.NONE)
@Execute(phase=LifecyclePhase.NONE)
public class DeployFunction
extends CloudSdkMojo {
    @Parameter(alias="deploy.projectId", property="function.deploy.projectId")
    protected String projectId;
    @Parameter(alias="deploy.name", property="function.deploy.name", required=true)
    String name;
    @Parameter(alias="deploy.region", property="function.deploy.region")
    String region;
    @Parameter(alias="deploy.allowunauthenticated", property="function.deploy.allowunauthenticated", defaultValue="false")
    boolean allowUnauthenticated;
    @Parameter(alias="deploy.functiontarget", property="function.deploy.functiontarget")
    String functionTarget;
    @Parameter(alias="deploy.ignorefile", property="function.deploy.ignorefile")
    String ignoreFile;
    @Parameter(alias="deploy.memory", property="function.deploy.memory")
    String memory;
    @Parameter(alias="deploy.retry", property="function.deploy.retry")
    String retry;
    @Parameter(alias="deploy.runtime", defaultValue="java11", property="function.deploy.runtime")
    String runtime = "java11";
    @Parameter(alias="deploy.serviceaccount", property="function.deploy.serviceaccount")
    String serviceAccount;
    @Parameter(alias="deploy.source", property="function.deploy.source")
    String source;
    @Parameter(alias="deploy.stagebucket", property="function.deploy.stagebucket")
    String stageBucket;
    @Parameter(alias="deploy.timeout", property="function.deploy.timeout")
    String timeout;
    @Parameter(alias="deploy.updatelabels", property="function.deploy.updatelabels")
    List<String> updateLabels;
    @Parameter(alias="deploy.triggerhttp", property="function.deploy.triggerhttp")
    Boolean triggerHttp;
    @Parameter(alias="deploy.triggertopic", property="function.deploy.triggertopic")
    String triggerTopic;
    @Parameter(alias="deploy.triggerevent", property="function.deploy.triggerevent")
    String triggerEvent;
    @Parameter(alias="deploy.triggerresource", property="function.deploy.triggerresource")
    String triggerResource;
    @Parameter(alias="deploy.vpcconnector", property="function.deploy.vpcconnector")
    String vpcConnector;
    @Parameter(alias="deploy.maxinstances", property="function.deploy.maxinstances")
    Integer maxInstances;
    @Parameter(alias="deploy.setenvvars", property="function.deploy.setenvvars")
    Map<String, String> environmentVariables;
    @Parameter(alias="deploy.envvarsfile", property="function.deploy.envvarsfile")
    String envVarsFile;

    boolean hasEnvVariables() {
        return this.environmentVariables != null && !this.environmentVariables.isEmpty();
    }

    static Function<String, ManagedCloudSdk> newManagedSdkFactory() {
        return version -> {
            try {
                if (Strings.isNullOrEmpty((String)version)) {
                    return ManagedCloudSdk.newManagedSdk();
                }
                return ManagedCloudSdk.newManagedSdk((Version)new Version(version));
            }
            catch (BadCloudSdkVersionException | UnsupportedOsException ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    CloudSdk buildCloudSdkMinimal() {
        return DeployFunction.buildCloudSdk(this, new CloudSdkChecker(), new CloudSdkDownloader(DeployFunction.newManagedSdkFactory()));
    }

    static CloudSdk buildCloudSdk(CloudSdkMojo mojo, CloudSdkChecker cloudSdkChecker, CloudSdkDownloader cloudSdkDownloader) {
        try {
            if (mojo.getCloudSdkHome() != null) {
                CloudSdk cloudSdk = new CloudSdk.Builder().sdkPath(mojo.getCloudSdkHome()).build();
                if (mojo.getCloudSdkVersion() != null) {
                    cloudSdkChecker.checkCloudSdk(cloudSdk, mojo.getCloudSdkVersion());
                }
                return cloudSdk;
            }
            return new CloudSdk.Builder().sdkPath(cloudSdkDownloader.downloadIfNecessary(mojo.getCloudSdkVersion(), mojo.getLog(), Collections.emptyList(), mojo.getMavenSession().isOffline())).build();
        }
        catch (CloudSdkNotFoundException | CloudSdkOutOfDateException | CloudSdkVersionFileException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Gcloud getGcloud() {
        return Gcloud.builder((CloudSdk)this.buildCloudSdkMinimal()).setMetricsEnvironment(this.getArtifactId(), this.getArtifactVersion()).setCredentialFile(this.getServiceAccountKeyFile()).build();
    }

    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("functions");
        commands.add("deploy");
        commands.add(this.name);
        if (this.region != null) {
            commands.add("--region=" + this.region);
        }
        if (this.triggerResource == null && this.triggerTopic == null && this.triggerEvent == null) {
            commands.add("--trigger-http");
        }
        if (this.triggerResource != null) {
            commands.add("--trigger-resource=" + this.triggerResource);
        }
        if (this.triggerTopic != null) {
            commands.add("--trigger-topic=" + this.triggerTopic);
        }
        if (this.triggerEvent != null) {
            commands.add("--trigger-event=" + this.triggerEvent);
        }
        if (this.allowUnauthenticated) {
            commands.add("--allow-unauthenticated");
        }
        if (this.functionTarget != null) {
            commands.add("--entry-point=" + this.functionTarget);
        }
        if (this.ignoreFile != null) {
            commands.add("--ignore-file=" + this.ignoreFile);
        }
        if (this.memory != null) {
            commands.add("--memory=" + this.memory);
        }
        if (this.retry != null) {
            commands.add("--retry=" + this.retry);
        }
        if (this.serviceAccount != null) {
            commands.add("--service-account=" + this.serviceAccount);
        }
        if (this.source != null) {
            commands.add("--source=" + this.source);
        }
        if (this.stageBucket != null) {
            commands.add("--stage-bucket=" + this.stageBucket);
        }
        if (this.timeout != null) {
            commands.add("--timeout=" + this.timeout);
        }
        if (this.updateLabels != null && !this.updateLabels.isEmpty()) {
            commands.add("--update-labels=" + String.join((CharSequence)",", this.updateLabels));
        }
        if (this.vpcConnector != null) {
            commands.add("--vpc-connector=" + this.vpcConnector);
        }
        if (this.maxInstances != null) {
            commands.add("--max-instances=" + this.maxInstances);
        }
        if (this.hasEnvVariables()) {
            Joiner.MapJoiner mapJoiner = Joiner.on((String)",").withKeyValueSeparator("=");
            commands.add("--set-env-vars=" + mapJoiner.join(this.environmentVariables));
        }
        if (this.envVarsFile != null) {
            commands.add("--env-vars-file=" + this.envVarsFile);
        }
        commands.add("--runtime=" + this.runtime);
        if (this.projectId != null) {
            commands.add("--project=" + this.projectId);
        }
        return Collections.unmodifiableList(commands);
    }

    public void execute() throws MojoExecutionException {
        try {
            Gcloud gcloud = this.getGcloud();
            List<String> params = this.getCommands();
            System.out.println("Executing Cloud SDK command: gcloud " + String.join((CharSequence)" ", params));
            gcloud.runCommand(params);
        }
        catch (CloudSdkNotFoundException | ProcessHandlerException | IOException ex) {
            Logger.getLogger(DeployFunction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

