/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.read.DefaultReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.cloud.bigtable.hbase.util.ByteStringer;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.hadoop.hbase.client.Scan;

@InternalExtensionOnly
public class CloudBigtableScanConfiguration
extends CloudBigtableTableConfiguration {
    private static final long serialVersionUID = 2435897354284600685L;
    protected static final String PLACEHOLDER_TABLE_ID = "PLACEHOLDER_TABLE_ID";
    protected static final String PLACEHOLDER_PROJECT_ID = "PLACEHOLDER_PROJECT_ID";
    protected static final String PLACEHOLDER_INSTANCE_ID = "PLACEHOLDER_INSTANCE_ID";
    protected static final String PLACEHOLDER_APP_PROFILE_ID = "PLACEHOLDER_APP_PROFILE_ID";
    private final ValueProvider<ReadRowsRequest> request;

    public static CloudBigtableScanConfiguration fromConfig(CloudBigtableTableConfiguration config, Scan scan) {
        Builder builder = new Builder();
        config.copyConfig(builder);
        return builder.withScan(scan).build();
    }

    protected CloudBigtableScanConfiguration(ValueProvider<String> projectId, ValueProvider<String> instanceId, ValueProvider<String> tableId, ValueProvider<ReadRowsRequest> request, Map<String, ValueProvider<String>> additionalConfiguration) {
        super(projectId, instanceId, tableId, additionalConfiguration);
        this.request = new RequestWithTableNameValueProvider(projectId, instanceId, tableId, request);
    }

    @Deprecated
    public ReadRowsRequest getRequest() {
        return (ReadRowsRequest)this.request.get();
    }

    public byte[] getStartRow() {
        return this.getStartRowByteString().toByteArray();
    }

    public byte[] getStopRow() {
        return this.getStopRowByteString().toByteArray();
    }

    byte[] getZeroCopyStartRow() {
        return ByteStringer.extract((ByteString)this.getStartRowByteString());
    }

    byte[] getZeroCopyStopRow() {
        return ByteStringer.extract((ByteString)this.getStopRowByteString());
    }

    ByteString getStartRowByteString() {
        return this.getRowRange().getStartKeyClosed();
    }

    ByteString getStopRowByteString() {
        return this.getRowRange().getEndKeyOpen();
    }

    RowRange getRowRange() {
        RowSet rows = this.getRequest().getRows();
        return rows.getRowRanges(0);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.getRequest(), ((CloudBigtableScanConfiguration)obj).getRequest());
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        this.copyConfig(builder);
        return builder;
    }

    public void copyConfig(Builder builder) {
        super.copyConfig(builder);
        builder.withRequest(this.getRequest());
    }

    public ByteKeyRange toByteKeyRange() {
        return ByteKeyRange.of((ByteKey)ByteKey.copyFrom((byte[])this.getZeroCopyStartRow()), (ByteKey)ByteKey.copyFrom((byte[])this.getZeroCopyStopRow()));
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"readRowsRequest", (String)CloudBigtableScanConfiguration.getDisplayValue(this.request)).withLabel("ReadRowsRequest"));
    }

    private static class RequestWithTableNameValueProvider
    implements ValueProvider<ReadRowsRequest>,
    Serializable {
        private final ValueProvider<String> projectId;
        private final ValueProvider<String> instanceId;
        private final ValueProvider<String> tableId;
        private final ValueProvider<ReadRowsRequest> request;
        private ReadRowsRequest cachedRequest;

        RequestWithTableNameValueProvider(ValueProvider<String> projectId, ValueProvider<String> instanceId, ValueProvider<String> tableId, ValueProvider<ReadRowsRequest> request) {
            this.projectId = projectId;
            this.instanceId = instanceId;
            this.tableId = tableId;
            this.request = request;
        }

        public ReadRowsRequest get() {
            if (this.cachedRequest == null) {
                if (((ReadRowsRequest)this.request.get()).getTableName().isEmpty()) {
                    String fullTableName = NameUtil.formatTableName((String)((String)this.projectId.get()), (String)((String)this.instanceId.get()), (String)((String)this.tableId.get()));
                    this.cachedRequest = ((ReadRowsRequest)this.request.get()).toBuilder().setTableName(fullTableName).build();
                } else {
                    this.cachedRequest = (ReadRowsRequest)this.request.get();
                }
            }
            return this.cachedRequest;
        }

        public boolean isAccessible() {
            return this.projectId.isAccessible() && this.instanceId.isAccessible() && this.tableId.isAccessible() && this.request.isAccessible();
        }

        public String toString() {
            if (this.isAccessible()) {
                return String.valueOf(this.get());
            }
            return "Unavailable during pipeline construction";
        }
    }

    public static class Builder
    extends CloudBigtableTableConfiguration.Builder {
        private ValueProvider<ReadRowsRequest> request;

        public Builder withScan(Scan scan) {
            Preconditions.checkArgument((scan != null ? 1 : 0) != 0, (Object)"Scan cannot be null");
            Query query = Query.create((String)CloudBigtableScanConfiguration.PLACEHOLDER_TABLE_ID);
            DefaultReadHooks readHooks = new DefaultReadHooks();
            Adapters.SCAN_ADAPTER.adapt(scan, (ReadHooks)readHooks, query);
            readHooks.applyPreSendHook(query);
            this.withQuery(query);
            return this;
        }

        Builder withQuery(Query query) {
            RequestContext dummyContext = RequestContext.create((String)CloudBigtableScanConfiguration.PLACEHOLDER_PROJECT_ID, (String)CloudBigtableScanConfiguration.PLACEHOLDER_INSTANCE_ID, (String)CloudBigtableScanConfiguration.PLACEHOLDER_APP_PROFILE_ID);
            return this.withRequest(query.toProto(dummyContext).toBuilder().setTableName("").setAppProfileId("").build());
        }

        @Deprecated
        public Builder withRequest(ReadRowsRequest request) {
            return this.withRequest((ValueProvider<ReadRowsRequest>)ValueProvider.StaticValueProvider.of((Object)request));
        }

        @Deprecated
        public Builder withRequest(ValueProvider<ReadRowsRequest> request) {
            this.request = request;
            return this;
        }

        Builder withKeys(byte[] startKey, byte[] stopKey) {
            Preconditions.checkNotNull(this.request, (Object)"Request cannot be empty.");
            Preconditions.checkState((boolean)this.request.isAccessible(), (Object)"Request must be accessible.");
            ByteString start = ByteStringer.wrap((byte[])startKey);
            ByteString stop = ByteStringer.wrap((byte[])stopKey);
            return this.withRequest(((ReadRowsRequest)this.request.get()).toBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(start).setEndKeyOpen(stop))).build());
        }

        @Override
        public Builder withProjectId(String projectId) {
            super.withProjectId(projectId);
            return this;
        }

        @Override
        public Builder withProjectId(ValueProvider<String> projectId) {
            super.withProjectId((ValueProvider)projectId);
            return this;
        }

        @Override
        public Builder withInstanceId(String instanceId) {
            super.withInstanceId(instanceId);
            return this;
        }

        @Override
        public Builder withInstanceId(ValueProvider<String> instanceId) {
            super.withInstanceId((ValueProvider)instanceId);
            return this;
        }

        @Override
        public Builder withAppProfileId(String appProfileId) {
            super.withAppProfileId(appProfileId);
            return this;
        }

        @Override
        public Builder withAppProfileId(ValueProvider<String> appProfileId) {
            super.withAppProfileId((ValueProvider)appProfileId);
            return this;
        }

        @Override
        public Builder withConfiguration(String key, String value) {
            super.withConfiguration(key, value);
            return this;
        }

        @Override
        public Builder withConfiguration(String key, ValueProvider<String> value) {
            super.withConfiguration(key, (ValueProvider)value);
            return this;
        }

        @Override
        public Builder withTableId(String tableId) {
            super.withTableId(tableId);
            return this;
        }

        @Override
        public Builder withTableId(ValueProvider<String> tableId) {
            super.withTableId(tableId);
            return this;
        }

        @Override
        public CloudBigtableScanConfiguration build() {
            if (this.request == null) {
                this.withScan(new Scan());
            }
            return new CloudBigtableScanConfiguration((ValueProvider<String>)this.projectId, (ValueProvider<String>)this.instanceId, (ValueProvider<String>)this.tableId, this.request, this.additionalConfiguration);
        }
    }
}

