/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import java.nio.charset.CharacterCodingException;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ParseFilter;

class ScanValueProvider
implements ValueProvider<Scan> {
    private final ValueProvider<String> start;
    private final ValueProvider<String> stop;
    private final ValueProvider<Integer> maxVersion;
    private final ValueProvider<String> filter;

    ScanValueProvider(ValueProvider<String> start, ValueProvider<String> stop, ValueProvider<Integer> maxVersion, ValueProvider<String> filter) {
        this.start = start;
        this.stop = stop;
        this.maxVersion = maxVersion;
        this.filter = filter;
    }

    public Scan get() {
        Scan scan = new Scan();
        scan.setMaxVersions(Integer.MAX_VALUE);
        if (this.start.get() != null && !((String)this.start.get()).isEmpty()) {
            scan.withStartRow(((String)this.start.get()).getBytes());
        }
        if (this.stop.get() != null && !((String)this.stop.get()).isEmpty()) {
            scan.withStopRow(((String)this.stop.get()).getBytes());
        }
        if (this.maxVersion.get() != null) {
            scan.setMaxVersions(((Integer)this.maxVersion.get()).intValue());
        }
        if (this.filter.get() != null && !((String)this.filter.get()).isEmpty()) {
            try {
                scan.setFilter(new ParseFilter().parseFilterString((String)this.filter.get()));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
        }
        return scan;
    }

    public boolean isAccessible() {
        return this.start.isAccessible() && this.stop.isAccessible() && this.maxVersion.isAccessible() && this.filter.isAccessible();
    }
}

