/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.bigtable.v2.TableName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import com.google.cloud.bigtable.beam.ScanValueProvider;
import com.google.cloud.bigtable.hbase.BigtableFixedProtoScan;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.read.DefaultReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;

@InternalExtensionOnly
public class CloudBigtableScanConfiguration
extends CloudBigtableTableConfiguration {
    private static final long serialVersionUID = 2435897354284600685L;
    protected static final String PLACEHOLDER_TABLE_ID = "PLACEHOLDER_TABLE_ID";
    protected static final String PLACEHOLDER_PROJECT_ID = "PLACEHOLDER_PROJECT_ID";
    protected static final String PLACEHOLDER_INSTANCE_ID = "PLACEHOLDER_INSTANCE_ID";
    protected static final String PLACEHOLDER_APP_PROFILE_ID = "PLACEHOLDER_APP_PROFILE_ID";
    private final ValueProvider<Scan> scanValueProvider;

    public static CloudBigtableScanConfiguration fromConfig(CloudBigtableTableConfiguration config, Scan scan) {
        Builder builder = new Builder();
        config.copyConfig(builder);
        return builder.withScan(scan).build();
    }

    public static CloudBigtableScanConfiguration createConfig(ValueProvider<String> projectId, ValueProvider<String> instanceId, ValueProvider<String> tableId, ValueProvider<Scan> scan, Map<String, ValueProvider<String>> configuration) {
        Builder builder = new Builder();
        for (String key : configuration.keySet()) {
            if (key.equals("google.bigtable.project.id") || key.equals("google.bigtable.instance.id")) continue;
            builder.withConfiguration(key, (ValueProvider)configuration.get(key));
        }
        return ((Builder)((Builder)((Builder)builder.withProjectId((ValueProvider)projectId)).withInstanceId((ValueProvider)instanceId)).withTableId((ValueProvider)tableId)).withScan(scan).build();
    }

    protected CloudBigtableScanConfiguration(ValueProvider<String> projectId, ValueProvider<String> instanceId, ValueProvider<String> tableId, ValueProvider<Scan> scanValueProvider, Map<String, ValueProvider<String>> additionalConfiguration) {
        super(projectId, instanceId, tableId, additionalConfiguration);
        this.scanValueProvider = new ScanWithTableNameValueProvider(projectId, instanceId, tableId, scanValueProvider);
    }

    @Deprecated
    public ReadRowsRequest getRequest() {
        Preconditions.checkNotNull(this.scanValueProvider, (Object)"Scan cannot be empty.");
        Preconditions.checkState((boolean)this.scanValueProvider.isAccessible(), (Object)"Scan must be accessible.");
        if (this.scanValueProvider.get() instanceof BigtableFixedProtoScan) {
            return ((BigtableFixedProtoScan)this.scanValueProvider.get()).getRequest();
        }
        Scan hbaseScan = null;
        if (this.scanValueProvider instanceof ScanValueProvider) {
            hbaseScan = (Scan)this.scanValueProvider.get();
        }
        DefaultReadHooks readHooks = new DefaultReadHooks();
        Query query = Query.create((String)this.getTableId());
        query = Adapters.SCAN_ADAPTER.adapt(hbaseScan == null ? (Scan)this.scanValueProvider.get() : hbaseScan, (ReadHooks)readHooks, query);
        readHooks.applyPreSendHook(query);
        return query.toProto(RequestContext.create((String)this.getProjectId(), (String)this.getInstanceId(), (String)this.getAppProfileId()));
    }

    public ValueProvider<Scan> getScanValueProvider() {
        return this.scanValueProvider;
    }

    public byte[] getStartRow() {
        return this.getRowRange().getStartKeyClosed().toByteArray();
    }

    public byte[] getStopRow() {
        return this.getRowRange().getEndKeyOpen().toByteArray();
    }

    RowRange getRowRange() {
        Scan scan = (Scan)this.scanValueProvider.get();
        if (scan instanceof BigtableFixedProtoScan) {
            return ((BigtableFixedProtoScan)scan).getRequest().getRows().getRowRanges(0);
        }
        return RowRange.newBuilder().setStartKeyClosed(ByteString.copyFrom((byte[])scan.getStartRow())).setEndKeyOpen(ByteString.copyFrom((byte[])scan.getStopRow())).build();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.getRequest(), ((CloudBigtableScanConfiguration)obj).getRequest());
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        this.copyConfig(builder);
        return builder;
    }

    public void copyConfig(Builder builder) {
        super.copyConfig(builder);
        builder.withRequest(this.getRequest());
    }

    public ByteKeyRange toByteKeyRange() {
        return ByteKeyRange.of((ByteKey)ByteKey.copyFrom((byte[])this.getStartRow()), (ByteKey)ByteKey.copyFrom((byte[])this.getStopRow()));
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"scan", (String)CloudBigtableScanConfiguration.getDisplayValue(this.scanValueProvider)).withLabel("Scan"));
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy
    implements Serializable {
        private ValueProvider<String> projectId;
        private ValueProvider<String> instanceId;
        private ValueProvider<String> tableId;
        private transient ValueProvider<Scan> scan;
        private ImmutableMap<String, ValueProvider<String>> additionalConfiguration;

        public SerializationProxy(CloudBigtableScanConfiguration configuration) {
            this.projectId = configuration.getProjectIdValueProvider();
            this.instanceId = configuration.getInstanceIdValueProvider();
            this.tableId = configuration.getTableIdValueProvider();
            this.scan = configuration.getScanValueProvider();
            HashMap<String, ValueProvider<String>> map = new HashMap<String, ValueProvider<String>>();
            map.putAll((Map<String, ValueProvider<String>>)configuration.getConfiguration());
            map.remove("google.bigtable.project.id");
            map.remove("google.bigtable.instance.id");
            this.additionalConfiguration = new ImmutableMap.Builder().putAll(map).build();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            if (this.scan.isAccessible()) {
                Scan scanValue = (Scan)this.scan.get();
                if (scanValue instanceof BigtableFixedProtoScan) {
                    out.writeObject((Object)ScanType.FIXED);
                    out.writeObject(((BigtableFixedProtoScan)scanValue).getRequest());
                } else {
                    out.writeObject((Object)ScanType.HBASE);
                    ProtobufUtil.toScan((Scan)scanValue).writeDelimitedTo((OutputStream)out);
                }
            } else {
                out.writeObject((Object)ScanType.DEFER);
                out.writeObject(this.scan);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            ScanType scanType = (ScanType)((Object)in.readObject());
            if (scanType == ScanType.FIXED) {
                ReadRowsRequest request = (ReadRowsRequest)in.readObject();
                this.scan = ValueProvider.StaticValueProvider.of((Object)new BigtableFixedProtoScan(request));
            } else {
                this.scan = scanType == ScanType.DEFER ? (ValueProvider)in.readObject() : ValueProvider.StaticValueProvider.of((Object)ProtobufUtil.toScan((ClientProtos.Scan)ClientProtos.Scan.parseDelimitedFrom((InputStream)in)));
            }
        }

        Object readResolve() {
            return new CloudBigtableScanConfiguration(this.projectId, this.instanceId, this.tableId, this.scan, (Map<String, ValueProvider<String>>)this.additionalConfiguration);
        }
    }

    private static class ScanWithTableNameValueProvider
    implements ValueProvider<Scan>,
    Serializable {
        private final ValueProvider<String> projectId;
        private final ValueProvider<String> instanceId;
        private final ValueProvider<String> tableId;
        private final ValueProvider<Scan> scanValueProvider;
        private Scan cachedScan;

        ScanWithTableNameValueProvider(ValueProvider<String> projectId, ValueProvider<String> instanceId, ValueProvider<String> tableId, ValueProvider<Scan> scan) {
            this.projectId = projectId;
            this.instanceId = instanceId;
            this.tableId = tableId;
            this.scanValueProvider = scan;
        }

        public Scan get() {
            if (this.cachedScan == null) {
                if (this.scanValueProvider == null) {
                    this.cachedScan = new Scan();
                    this.cachedScan.setMaxVersions(Integer.MAX_VALUE);
                } else {
                    this.cachedScan = (Scan)this.scanValueProvider.get();
                }
            }
            return this.cachedScan;
        }

        public boolean isAccessible() {
            return this.projectId.isAccessible() && this.instanceId.isAccessible() && this.tableId.isAccessible() && this.scanValueProvider.isAccessible();
        }

        public String toString() {
            if (this.isAccessible()) {
                return String.valueOf(this.get());
            }
            return "Unavailable during pipeline construction";
        }
    }

    public static class Builder
    extends CloudBigtableTableConfiguration.Builder {
        private transient ValueProvider<Scan> scan;

        public Builder withScan(Scan scan) {
            return this.withScan((ValueProvider<Scan>)ValueProvider.StaticValueProvider.of((Object)scan));
        }

        public Builder withScan(ValueProvider<Scan> scan) {
            this.scan = scan;
            return this;
        }

        @Deprecated
        public Builder withRequest(ReadRowsRequest request) {
            return this.withScan((Scan)new BigtableFixedProtoScan(request));
        }

        @Deprecated
        public Builder withRequest(ValueProvider<ReadRowsRequest> request) {
            Preconditions.checkState((boolean)request.isAccessible(), (Object)"request should be accessible");
            return this.withScan((Scan)new BigtableFixedProtoScan((ReadRowsRequest)request.get()));
        }

        Builder withKeys(byte[] startKey, byte[] stopKey) {
            Preconditions.checkNotNull(this.scan, (Object)"Scan cannot be empty.");
            Preconditions.checkState((boolean)this.scan.isAccessible(), (Object)"Scan must be accessible.");
            ByteString start = ByteString.copyFrom((byte[])startKey);
            ByteString end = ByteString.copyFrom((byte[])stopKey);
            if (this.scan.get() instanceof BigtableFixedProtoScan) {
                ReadRowsRequest.Builder request = ((BigtableFixedProtoScan)this.scan.get()).getRequest().toBuilder();
                request.setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(start).setEndKeyOpen(end)));
                return this.withRequest(request.build());
            }
            return this.withScan(((Scan)this.scan.get()).withStartRow(startKey).withStopRow(stopKey));
        }

        @Override
        public Builder withProjectId(String projectId) {
            super.withProjectId(projectId);
            return this;
        }

        @Override
        public Builder withProjectId(ValueProvider<String> projectId) {
            super.withProjectId((ValueProvider)projectId);
            return this;
        }

        @Override
        public Builder withInstanceId(String instanceId) {
            super.withInstanceId(instanceId);
            return this;
        }

        @Override
        public Builder withInstanceId(ValueProvider<String> instanceId) {
            super.withInstanceId((ValueProvider)instanceId);
            return this;
        }

        @Override
        public Builder withAppProfileId(String appProfileId) {
            super.withAppProfileId(appProfileId);
            return this;
        }

        @Override
        public Builder withAppProfileId(ValueProvider<String> appProfileId) {
            super.withAppProfileId((ValueProvider)appProfileId);
            return this;
        }

        @Override
        public Builder withConfiguration(String key, String value) {
            super.withConfiguration(key, value);
            return this;
        }

        @Override
        public Builder withConfiguration(String key, ValueProvider<String> value) {
            super.withConfiguration(key, (ValueProvider)value);
            return this;
        }

        @Override
        public Builder withTableId(String tableId) {
            super.withTableId(tableId);
            return this;
        }

        @Override
        public Builder withTableId(ValueProvider<String> tableId) {
            super.withTableId(tableId);
            return this;
        }

        @Override
        public CloudBigtableScanConfiguration build() {
            if (this.scan == null) {
                this.scan = ValueProvider.StaticValueProvider.of((Object)new BigtableFixedProtoScan(ReadRowsRequest.newBuilder().setTableName(TableName.format((String)((String)this.projectId.get()), (String)((String)this.instanceId.get()), (String)((String)this.tableId.get()))).setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().build()).build()).build()));
            }
            return new CloudBigtableScanConfiguration((ValueProvider<String>)this.projectId, (ValueProvider<String>)this.instanceId, (ValueProvider<String>)this.tableId, this.scan, this.additionalConfiguration);
        }
    }

    static enum ScanType {
        FIXED,
        HBASE,
        DEFER;

    }
}

