/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.base.Joiner;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import java.util.List;

@InternalApi(value="For internal usage only")
public class UnsupportedFilterException
extends UnsupportedOperationException {
    private static final long serialVersionUID = -8737704632500918999L;
    private static Joiner STATUS_JOINER = Joiner.on(", ");
    private final List<FilterSupportStatus> filterSupportStatuses;

    public UnsupportedFilterException(List<FilterSupportStatus> filterSupportStatuses) {
        super(String.format("Unsupported filters encountered: %s", STATUS_JOINER.join(filterSupportStatuses)));
        Preconditions.checkArgument(!filterSupportStatuses.isEmpty(), "Unsupported statuses should not be empty.");
        this.filterSupportStatuses = filterSupportStatuses;
    }

    public List<FilterSupportStatus> getFilterSupportStatuses() {
        return this.filterSupportStatuses;
    }
}

