/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;

@InternalApi(value="For internal usage only")
public class ColumnPrefixFilterAdapter
extends TypedFilterAdapterBase<ColumnPrefixFilter> {
    @Override
    public Filters.Filter adapt(FilterAdapterContext context, ColumnPrefixFilter filter) throws IOException {
        byte[] prefix = filter.getPrefix();
        ByteString.Output outputStream = ByteString.newOutput(prefix.length * 2);
        ReaderExpressionHelper.writeQuotedExpression(outputStream, prefix);
        outputStream.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
        return Filters.FILTERS.qualifier().regex(outputStream.toByteString());
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, ColumnPrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

