/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.util.OperationAccountant;
import com.google.cloud.bigtable.hbase.wrappers.BigtableApi;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase.wrappers.BulkMutationWrapper;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;

@InternalApi(value="For internal usage only")
public class BigtableBufferedMutatorHelper {
    protected static final Logger LOG = new Logger(BigtableBufferedMutatorHelper.class);
    private final ReentrantReadWriteLock isClosedLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock closedReadLock = this.isClosedLock.readLock();
    private final ReentrantReadWriteLock.WriteLock closedWriteLock = this.isClosedLock.writeLock();
    private boolean closed = false;
    private final HBaseRequestAdapter adapter;
    private final BulkMutationWrapper bulkMutation;
    private final DataClientWrapper dataClient;
    private final BigtableHBaseSettings settings;
    private final OperationAccountant operationAccountant;

    public BigtableBufferedMutatorHelper(BigtableApi bigtableApi, BigtableHBaseSettings settings, HBaseRequestAdapter adapter) {
        this.adapter = adapter;
        this.settings = settings;
        this.dataClient = bigtableApi.getDataClient();
        this.bulkMutation = this.dataClient.createBulkMutation(this.adapter.getTableId(), settings.getBulkMutationCloseTimeoutMilliseconds());
        this.operationAccountant = new OperationAccountant();
    }

    public void close() throws IOException {
        this.closedWriteLock.lock();
        try {
            this.bulkMutation.close();
            this.closed = true;
        }
        finally {
            this.closedWriteLock.unlock();
        }
    }

    public void flush() throws IOException {
        if (this.bulkMutation != null) {
            try {
                this.bulkMutation.flush();
                this.operationAccountant.awaitCompletion();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("flush() was interrupted", e);
            }
        }
    }

    public void sendUnsent() {
        if (this.bulkMutation != null) {
            this.bulkMutation.sendUnsent();
        }
    }

    public Configuration getConfiguration() {
        return this.settings.getConfiguration();
    }

    public TableName getName() {
        return this.adapter.getTableName();
    }

    public long getWriteBufferSize() {
        return this.settings.getBatchingMaxRequestSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApiFuture<?>> mutate(List<? extends Mutation> mutations) {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            ArrayList futures = new ArrayList(mutations.size());
            for (Mutation mutation : mutations) {
                futures.add(this.offer(mutation));
            }
            ArrayList<ApiFuture<?>> arrayList = futures;
            return arrayList;
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    public ApiFuture<?> mutate(Mutation mutation) {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            ApiFuture<?> apiFuture = this.offer(mutation);
            return apiFuture;
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    public ApiFuture<?> mutate(RowMutations mutation) {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            if (mutation == null) {
                ApiFuture apiFuture = ApiFutures.immediateFailedFuture(new IllegalArgumentException("Cannot perform a mutation on a null object."));
                return apiFuture;
            }
            ApiFuture<Void> apiFuture = this.bulkMutation.add(this.adapter.adaptEntry(mutation));
            return apiFuture;
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    private ApiFuture<?> offer(Mutation mutation) {
        ApiFuture<Object> future = null;
        try {
            if (mutation == null) {
                future = ApiFutures.immediateFailedFuture(new IllegalArgumentException("Cannot perform a mutation on a null object."));
            } else if (mutation instanceof Put) {
                future = this.bulkMutation.add(this.adapter.adaptEntry((Put)mutation));
            } else if (mutation instanceof Delete) {
                future = this.bulkMutation.add(this.adapter.adaptEntry((Delete)mutation));
            } else if (mutation instanceof Increment) {
                future = this.dataClient.readModifyWriteRowAsync(this.adapter.adapt((Increment)mutation));
                this.operationAccountant.registerOperation(future);
            } else if (mutation instanceof Append) {
                future = this.dataClient.readModifyWriteRowAsync(this.adapter.adapt((Append)mutation));
                this.operationAccountant.registerOperation(future);
            } else {
                future = ApiFutures.immediateFailedFuture(new IllegalArgumentException("Encountered unknown mutation type: " + mutation.getClass()));
            }
        }
        catch (Exception e) {
            future = ApiFutures.immediateFailedFuture(e);
        }
        return future;
    }
}

