/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.bigtable.hbase.BigtableBufferedMutatorHelper;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.BigtableApi;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;

@InternalApi(value="For internal usage only")
public class BigtableBufferedMutator
implements BufferedMutator {
    protected static final Logger LOG = new Logger(BigtableBufferedMutator.class);
    private final BigtableBufferedMutatorHelper helper;
    private final BufferedMutator.ExceptionListener listener;
    private final AtomicBoolean hasExceptions = new AtomicBoolean(false);
    private final List<MutationException> globalExceptions = new ArrayList<MutationException>();
    private final String host;

    public BigtableBufferedMutator(BigtableApi bigtableApi, BigtableHBaseSettings settings, HBaseRequestAdapter adapter, BufferedMutator.ExceptionListener listener) {
        this.helper = new BigtableBufferedMutatorHelper(bigtableApi, settings, adapter);
        this.listener = listener;
        this.host = settings.getDataHost();
    }

    public void close() throws IOException {
        this.helper.close();
        this.handleExceptions();
    }

    public void flush() throws IOException {
        this.helper.flush();
        this.handleExceptions();
    }

    public Configuration getConfiguration() {
        return this.helper.getConfiguration();
    }

    public TableName getName() {
        return this.helper.getName();
    }

    public long getWriteBufferSize() {
        return this.helper.getWriteBufferSize();
    }

    public void mutate(List<? extends Mutation> mutations) throws IOException {
        this.handleExceptions();
        List<ApiFuture<?>> futures = this.helper.mutate(mutations);
        for (int i = 0; i < mutations.size(); ++i) {
            this.addCallback(futures.get(i), mutations.get(i));
        }
    }

    public void mutate(Mutation mutation) throws IOException {
        this.handleExceptions();
        this.addCallback(this.helper.mutate(mutation), mutation);
    }

    private void handleExceptions() throws RetriesExhaustedWithDetailsException {
        RetriesExhaustedWithDetailsException exceptions = this.getExceptions();
        if (exceptions != null) {
            this.listener.onException(exceptions, (BufferedMutator)this);
        }
    }

    private void addCallback(ApiFuture<?> future, Mutation mutation) {
        ApiFutures.addCallback(future, new ExceptionCallback((Row)mutation), MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RetriesExhaustedWithDetailsException getExceptions() throws RetriesExhaustedWithDetailsException {
        if (!this.hasExceptions.get()) {
            return null;
        }
        ArrayList<MutationException> mutationExceptions = null;
        List<MutationException> list = this.globalExceptions;
        synchronized (list) {
            this.hasExceptions.set(false);
            if (this.globalExceptions.isEmpty()) {
                return null;
            }
            mutationExceptions = new ArrayList<MutationException>(this.globalExceptions);
            this.globalExceptions.clear();
        }
        ArrayList<Throwable> problems = new ArrayList<Throwable>(mutationExceptions.size());
        ArrayList<String> hostnames = new ArrayList<String>(mutationExceptions.size());
        ArrayList<Row> failedMutations = new ArrayList<Row>(mutationExceptions.size());
        if (!mutationExceptions.isEmpty()) {
            LOG.warn("Exception occurred in BufferedMutator", mutationExceptions.get(0).throwable, new Object[0]);
        }
        for (MutationException mutationException : mutationExceptions) {
            problems.add(mutationException.throwable);
            failedMutations.add(mutationException.mutation);
            hostnames.add(this.host);
            LOG.debug("Exception occurred in BufferedMutator", mutationException.throwable, new Object[0]);
        }
        return new RetriesExhaustedWithDetailsException(problems, failedMutations, hostnames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGlobalException(Row mutation, Throwable t) {
        List<MutationException> list = this.globalExceptions;
        synchronized (list) {
            this.globalExceptions.add(new MutationException(mutation, t));
            this.hasExceptions.set(true);
        }
    }

    private class ExceptionCallback
    implements ApiFutureCallback {
        private final Row mutation;

        ExceptionCallback(Row mutation) {
            this.mutation = mutation;
        }

        @Override
        public void onFailure(Throwable t) {
            BigtableBufferedMutator.this.addGlobalException(this.mutation, t);
        }

        public void onSuccess(Object ignored) {
        }
    }

    private static class MutationException {
        private final Row mutation;
        private final Throwable throwable;

        MutationException(Row mutation, Throwable throwable) {
            this.mutation = mutation;
            this.throwable = throwable;
        }
    }
}

