/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent.TraceProtoUtils;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.common.v1.Node;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.trace.v1.CurrentLibraryConfig;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.trace.v1.TraceServiceGrpc;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.trace.v1.UpdatedLibraryConfig;
import com.google.bigtable.repackaged.io.opencensus.trace.config.TraceConfig;
import com.google.bigtable.repackaged.io.opencensus.trace.config.TraceParams;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class OcAgentTraceServiceConfigRpcHandler {
    private static final Logger logger = Logger.getLogger(OcAgentTraceServiceConfigRpcHandler.class.getName());
    @Nullable
    @GuardedBy(value="this")
    private StreamObserver<CurrentLibraryConfig> currentConfigObserver;
    @Nullable
    @GuardedBy(value="this")
    private Status terminateStatus;
    private final TraceConfig traceConfig;

    private OcAgentTraceServiceConfigRpcHandler(TraceConfig traceConfig) {
        this.traceConfig = traceConfig;
    }

    private synchronized void setCurrentConfigObserver(StreamObserver<CurrentLibraryConfig> currentConfigObserver) {
        this.currentConfigObserver = currentConfigObserver;
    }

    static OcAgentTraceServiceConfigRpcHandler create(TraceServiceGrpc.TraceServiceStub stub, TraceConfig traceConfig) {
        OcAgentTraceServiceConfigRpcHandler configRpcHandler = new OcAgentTraceServiceConfigRpcHandler(traceConfig);
        UpdatedLibraryConfigObserver updatedLibraryConfigObserver = new UpdatedLibraryConfigObserver(traceConfig, configRpcHandler);
        try {
            StreamObserver<CurrentLibraryConfig> currentConfigObserver = stub.config(updatedLibraryConfigObserver);
            configRpcHandler.setCurrentConfigObserver(currentConfigObserver);
        }
        catch (StatusRuntimeException e) {
            configRpcHandler.onComplete(e);
        }
        return configRpcHandler;
    }

    synchronized void sendInitialMessage(Node node) {
        com.google.bigtable.repackaged.io.opencensus.proto.trace.v1.TraceConfig currentTraceConfigProto = TraceProtoUtils.getCurrentTraceConfig(this.traceConfig);
        CurrentLibraryConfig firstConfig = CurrentLibraryConfig.newBuilder().setNode(node).setConfig(currentTraceConfigProto).build();
        this.sendCurrentConfig(firstConfig);
    }

    private synchronized void sendCurrentConfig() {
        com.google.bigtable.repackaged.io.opencensus.proto.trace.v1.TraceConfig currentTraceConfigProto = TraceProtoUtils.getCurrentTraceConfig(this.traceConfig);
        CurrentLibraryConfig currentLibraryConfig = CurrentLibraryConfig.newBuilder().setConfig(currentTraceConfigProto).build();
        this.sendCurrentConfig(currentLibraryConfig);
    }

    private synchronized void sendCurrentConfig(CurrentLibraryConfig currentLibraryConfig) {
        if (this.isCompleted() || this.currentConfigObserver == null) {
            return;
        }
        try {
            this.currentConfigObserver.onNext(currentLibraryConfig);
        }
        catch (Exception e) {
            this.onComplete(e);
        }
    }

    synchronized void onComplete(@Nullable Throwable error) {
        if (this.isCompleted()) {
            return;
        }
        this.currentConfigObserver = null;
        Status status = error == null ? Status.OK : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus() : Status.UNKNOWN);
        this.terminateStatus = status;
    }

    synchronized boolean isCompleted() {
        return this.terminateStatus != null;
    }

    @Nullable
    @VisibleForTesting
    synchronized Status getTerminateStatus() {
        return this.terminateStatus;
    }

    @VisibleForTesting
    static class UpdatedLibraryConfigObserver
    implements StreamObserver<UpdatedLibraryConfig> {
        private final TraceConfig traceConfig;
        private final OcAgentTraceServiceConfigRpcHandler configRpcHandler;

        @VisibleForTesting
        UpdatedLibraryConfigObserver(TraceConfig traceConfig, OcAgentTraceServiceConfigRpcHandler configRpcHandler) {
            this.traceConfig = traceConfig;
            this.configRpcHandler = configRpcHandler;
        }

        @Override
        public void onNext(UpdatedLibraryConfig value) {
            TraceParams updatedTraceParams = TraceProtoUtils.getUpdatedTraceParams(value, this.traceConfig);
            this.traceConfig.updateActiveTraceParams(updatedTraceParams);
            this.configRpcHandler.sendCurrentConfig();
        }

        @Override
        public void onError(Throwable t) {
            logger.log(Level.WARNING, "Config stream is disconnected.", t);
            this.configRpcHandler.onComplete(t);
        }

        @Override
        public void onCompleted() {
            this.configRpcHandler.onComplete(null);
        }
    }
}

