/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent;

import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.grpc.netty.NegotiationType;
import com.google.bigtable.repackaged.io.grpc.netty.NettyChannelBuilder;
import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent.OcAgentNodeUtils;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent.OcAgentTraceServiceExportRpcHandler;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent.TraceProtoUtils;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.util.TimeLimitedHandler;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.common.v1.Node;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.trace.v1.ExportTraceServiceRequest;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.trace.v1.TraceServiceGrpc;
import com.google.bigtable.repackaged.io.opencensus.trace.export.SpanData;
import io.netty.handler.ssl.SslContext;
import java.util.Collection;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class OcAgentTraceExporterHandler
extends TimeLimitedHandler {
    private static final Logger logger = Logger.getLogger(OcAgentTraceExporterHandler.class.getName());
    private static final String EXPORT_SPAN_NAME = "ExportOpenCensusProtoSpans";
    private final String endPoint;
    private final Node node;
    private final Boolean useInsecure;
    @Nullable
    private final SslContext sslContext;
    @Nullable
    private OcAgentTraceServiceExportRpcHandler exportRpcHandler;

    OcAgentTraceExporterHandler(String endPoint, String serviceName, boolean useInsecure, @Nullable SslContext sslContext, Duration retryInterval, boolean enableConfig, Duration deadline) {
        super(deadline, EXPORT_SPAN_NAME);
        this.endPoint = endPoint;
        this.node = OcAgentNodeUtils.getNodeInfo(serviceName);
        this.useInsecure = useInsecure;
        this.sslContext = sslContext;
    }

    @Override
    public void timeLimitedExport(Collection<SpanData> spanDataList) {
        if (this.exportRpcHandler == null || this.exportRpcHandler.isCompleted()) {
            TraceServiceGrpc.TraceServiceStub stub = OcAgentTraceExporterHandler.getTraceServiceStub(this.endPoint, this.useInsecure, this.sslContext);
            this.exportRpcHandler = OcAgentTraceExporterHandler.createExportRpcHandlerAndConnect(stub, this.node);
        }
        if (this.exportRpcHandler == null || this.exportRpcHandler.isCompleted()) {
            logger.info("Export RPC disconnected, dropping " + spanDataList.size() + " spans.");
            this.exportRpcHandler = null;
        } else {
            ExportTraceServiceRequest.Builder requestBuilder = ExportTraceServiceRequest.newBuilder();
            for (SpanData spanData : spanDataList) {
                requestBuilder.addSpans(TraceProtoUtils.toSpanProto(spanData));
            }
            this.exportRpcHandler.onExport(requestBuilder.build());
        }
    }

    @Nullable
    private static OcAgentTraceServiceExportRpcHandler createExportRpcHandlerAndConnect(TraceServiceGrpc.TraceServiceStub stub, Node node) {
        OcAgentTraceServiceExportRpcHandler exportRpcHandler;
        block2: {
            exportRpcHandler = null;
            try {
                exportRpcHandler = OcAgentTraceServiceExportRpcHandler.create(stub);
                ExportTraceServiceRequest firstExportReq = ExportTraceServiceRequest.newBuilder().setNode(node).build();
                exportRpcHandler.onExport(firstExportReq);
            }
            catch (RuntimeException e) {
                if (exportRpcHandler == null) break block2;
                exportRpcHandler.onComplete(e);
            }
        }
        return exportRpcHandler;
    }

    private static TraceServiceGrpc.TraceServiceStub getTraceServiceStub(String endPoint, Boolean useInsecure, SslContext sslContext) {
        Object channelBuilder = useInsecure != false ? ManagedChannelBuilder.forTarget(endPoint).usePlaintext() : NettyChannelBuilder.forTarget(endPoint).negotiationType(NegotiationType.TLS).sslContext(sslContext);
        ManagedChannel channel = ((ManagedChannelBuilder)channelBuilder).build();
        return TraceServiceGrpc.newStub(channel);
    }
}

