/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent.OcAgentMetricsExporterConfiguration;
import com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent.OcAgentMetricsExporterWorker;
import com.google.bigtable.repackaged.io.opencensus.metrics.Metrics;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricProducerManager;
import io.netty.handler.ssl.SslContext;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OcAgentMetricsExporter {
    private static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static OcAgentMetricsExporter exporter = null;
    private final Thread workerThread;

    public static void createAndRegister(OcAgentMetricsExporterConfiguration configuration) {
        Preconditions.checkNotNull(configuration, "configuration");
        OcAgentMetricsExporter.createInternal(configuration.getEndPoint(), configuration.getUseInsecure(), configuration.getSslContext(), configuration.getServiceName(), configuration.getExportInterval(), configuration.getRetryInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createInternal(String endPoint, boolean useInsecure, @Nullable SslContext sslContext, String serviceName, Duration exportInterval, Duration retryInterval) {
        Preconditions.checkArgument(useInsecure == (sslContext == null), "Either use insecure or provide a valid SslContext.");
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState(exporter == null, "OcAgent Metrics exporter is already created.");
            exporter = new OcAgentMetricsExporter(endPoint, useInsecure, sslContext, serviceName, exportInterval, retryInterval, Metrics.getExportComponent().getMetricProducerManager());
            OcAgentMetricsExporter.exporter.workerThread.start();
        }
    }

    private OcAgentMetricsExporter(String endPoint, Boolean useInsecure, @Nullable SslContext sslContext, String serviceName, Duration exportInterval, Duration retryInterval, MetricProducerManager metricProducerManager) {
        OcAgentMetricsExporterWorker worker = new OcAgentMetricsExporterWorker(endPoint, useInsecure, sslContext, exportInterval, retryInterval, serviceName, metricProducerManager);
        this.workerThread = new Thread(worker);
        this.workerThread.setDaemon(true);
        this.workerThread.setName("OcAgentMetricsExporterWorker");
    }
}

