/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds.internal.security.certprovider;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Internal;
import com.google.bigtable.repackaged.io.grpc.xds.Bootstrapper;
import com.google.bigtable.repackaged.io.grpc.xds.EnvoyServerProtoData;
import com.google.bigtable.repackaged.io.grpc.xds.internal.security.SslContextProvider;
import com.google.bigtable.repackaged.io.grpc.xds.internal.security.certprovider.CertProviderClientSslContextProvider;
import com.google.bigtable.repackaged.io.grpc.xds.internal.security.certprovider.CertProviderSslContextProvider;
import com.google.bigtable.repackaged.io.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class CertProviderClientSslContextProviderFactory {
    private static final CertProviderClientSslContextProviderFactory DEFAULT_INSTANCE = new CertProviderClientSslContextProviderFactory(CertificateProviderStore.getInstance());
    private final CertificateProviderStore certificateProviderStore;

    @VisibleForTesting
    public CertProviderClientSslContextProviderFactory(CertificateProviderStore certificateProviderStore) {
        this.certificateProviderStore = certificateProviderStore;
    }

    public static CertProviderClientSslContextProviderFactory getInstance() {
        return DEFAULT_INSTANCE;
    }

    public SslContextProvider getProvider(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders) {
        Preconditions.checkNotNull(upstreamTlsContext, "upstreamTlsContext");
        CommonTlsContext commonTlsContext = upstreamTlsContext.getCommonTlsContext();
        CertificateValidationContext staticCertValidationContext = CertProviderSslContextProvider.getStaticValidationContext(commonTlsContext);
        CommonTlsContext.CertificateProviderInstance rootCertInstance = CertProviderSslContextProvider.getRootCertProviderInstance(commonTlsContext);
        CommonTlsContext.CertificateProviderInstance certInstance = CertProviderSslContextProvider.getCertProviderInstance(commonTlsContext);
        return new CertProviderClientSslContextProvider(node, certProviders, certInstance, rootCertInstance, staticCertValidationContext, upstreamTlsContext, this.certificateProviderStore);
    }
}

