/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.InternalLogId;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.util.ForwardingLoadBalancerHelper;
import com.google.bigtable.repackaged.io.grpc.util.GracefulSwitchLoadBalancer;
import com.google.bigtable.repackaged.io.grpc.xds.AddressFilter;
import com.google.bigtable.repackaged.io.grpc.xds.WeightedRandomPicker;
import com.google.bigtable.repackaged.io.grpc.xds.WeightedTargetLoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.xds.XdsLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class WeightedTargetLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final Map<String, GracefulSwitchLoadBalancer> childBalancers = new HashMap<String, GracefulSwitchLoadBalancer>();
    private final Map<String, ChildHelper> childHelpers = new HashMap<String, ChildHelper>();
    private final LoadBalancer.Helper helper;
    private Map<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> targets = ImmutableMap.of();
    private boolean resolvingAddresses;

    WeightedTargetLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("weighted-target-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    public boolean acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        try {
            this.resolvingAddresses = true;
            boolean bl = this.acceptResolvedAddressesInternal(resolvedAddresses);
            return bl;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    public boolean acceptResolvedAddressesInternal(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull(lbConfig, "missing weighted_target lb config");
        WeightedTargetLoadBalancerProvider.WeightedTargetConfig weightedTargetConfig = (WeightedTargetLoadBalancerProvider.WeightedTargetConfig)lbConfig;
        Map<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> newTargets = weightedTargetConfig.targets;
        for (String targetName : newTargets.keySet()) {
            WeightedTargetLoadBalancerProvider.WeightedPolicySelection weightedChildLbConfig = newTargets.get(targetName);
            if (!this.targets.containsKey(targetName)) {
                ChildHelper childHelper = new ChildHelper(targetName);
                GracefulSwitchLoadBalancer childBalancer = new GracefulSwitchLoadBalancer(childHelper);
                childBalancer.switchTo(weightedChildLbConfig.policySelection.getProvider());
                this.childHelpers.put(targetName, childHelper);
                this.childBalancers.put(targetName, childBalancer);
                continue;
            }
            if (weightedChildLbConfig.policySelection.getProvider().equals(this.targets.get((Object)targetName).policySelection.getProvider())) continue;
            this.childBalancers.get(targetName).switchTo(weightedChildLbConfig.policySelection.getProvider());
        }
        this.targets = newTargets;
        for (String targetName : this.targets.keySet()) {
            this.childBalancers.get(targetName).handleResolvedAddresses(resolvedAddresses.toBuilder().setAddresses(AddressFilter.filter(resolvedAddresses.getAddresses(), targetName)).setLoadBalancingPolicyConfig(this.targets.get((Object)targetName).policySelection.getConfig()).build());
        }
        for (String targetName : this.childBalancers.keySet()) {
            if (this.targets.containsKey(targetName)) continue;
            this.childBalancers.get(targetName).shutdown();
        }
        this.childBalancers.keySet().retainAll(this.targets.keySet());
        this.childHelpers.keySet().retainAll(this.targets.keySet());
        this.updateOverallBalancingState();
        return true;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.childBalancers.isEmpty()) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.ErrorPicker(error));
        }
        for (LoadBalancer loadBalancer : this.childBalancers.values()) {
            loadBalancer.handleNameResolutionError(error);
        }
    }

    @Override
    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    @Override
    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        for (LoadBalancer loadBalancer : this.childBalancers.values()) {
            loadBalancer.shutdown();
        }
        this.childBalancers.clear();
    }

    private void updateOverallBalancingState() {
        ArrayList<WeightedRandomPicker.WeightedChildPicker> childPickers = new ArrayList<WeightedRandomPicker.WeightedChildPicker>();
        ConnectivityState overallState = null;
        ArrayList<WeightedRandomPicker.WeightedChildPicker> errorPickers = new ArrayList<WeightedRandomPicker.WeightedChildPicker>();
        for (String name : this.targets.keySet()) {
            ChildHelper childHelper = this.childHelpers.get(name);
            ConnectivityState childState = childHelper.currentState;
            overallState = WeightedTargetLoadBalancer.aggregateState(overallState, childState);
            int weight = this.targets.get((Object)name).weight;
            if (ConnectivityState.READY == childState) {
                childPickers.add(new WeightedRandomPicker.WeightedChildPicker(weight, childHelper.currentPicker));
                continue;
            }
            if (ConnectivityState.TRANSIENT_FAILURE != childState) continue;
            errorPickers.add(new WeightedRandomPicker.WeightedChildPicker(weight, childHelper.currentPicker));
        }
        LoadBalancer.SubchannelPicker picker = childPickers.isEmpty() ? (overallState == ConnectivityState.TRANSIENT_FAILURE ? new WeightedRandomPicker(errorPickers) : LoadBalancer.EMPTY_PICKER) : new WeightedRandomPicker(childPickers);
        if (overallState != null) {
            this.helper.updateBalancingState(overallState, picker);
        }
    }

    @Nullable
    private static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    private final class ChildHelper
    extends ForwardingLoadBalancerHelper {
        String name;
        ConnectivityState currentState = ConnectivityState.CONNECTING;
        LoadBalancer.SubchannelPicker currentPicker = LoadBalancer.EMPTY_PICKER;

        private ChildHelper(String name) {
            this.name = name;
        }

        @Override
        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.currentState = newState;
            this.currentPicker = newPicker;
            if (!WeightedTargetLoadBalancer.this.resolvingAddresses && WeightedTargetLoadBalancer.this.childBalancers.containsKey(this.name)) {
                WeightedTargetLoadBalancer.this.updateOverallBalancingState();
            }
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return WeightedTargetLoadBalancer.this.helper;
        }
    }
}

