/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.com.google.common.base.Supplier;
import com.google.bigtable.repackaged.com.google.protobuf.util.Durations;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.InternalLogId;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.SynchronizationContext;
import com.google.bigtable.repackaged.io.grpc.internal.BackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.bigtable.repackaged.io.grpc.xds.EnvoyProtoData;
import com.google.bigtable.repackaged.io.grpc.xds.LoadStatsManager2;
import com.google.bigtable.repackaged.io.grpc.xds.Stats;
import com.google.bigtable.repackaged.io.grpc.xds.XdsLogger;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterStats;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.EndpointLoadMetricStats;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.UpstreamLocalityStats;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadReportingServiceGrpc;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsRequest;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class LoadReportClient {
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final Channel channel;
    private final Context context;
    private final EnvoyProtoData.Node node;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timerService;
    private final Stopwatch retryStopwatch;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    @VisibleForTesting
    final LoadStatsManager2 loadStatsManager;
    private boolean started;
    @Nullable
    private BackoffPolicy lrsRpcRetryPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle lrsRpcRetryTimer;
    @Nullable
    @VisibleForTesting
    LrsStream lrsStream;

    LoadReportClient(LoadStatsManager2 loadStatsManager, Channel channel, Context context, EnvoyProtoData.Node node, SynchronizationContext syncContext, ScheduledExecutorService scheduledExecutorService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.loadStatsManager = Preconditions.checkNotNull(loadStatsManager, "loadStatsManager");
        this.channel = Preconditions.checkNotNull(channel, "xdsChannel");
        this.context = Preconditions.checkNotNull(context, "context");
        this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext");
        this.timerService = Preconditions.checkNotNull(scheduledExecutorService, "timeService");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.retryStopwatch = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier").get();
        this.node = Preconditions.checkNotNull(node, "node").toBuilder().addClientFeatures("envoy.lrs.supports_send_all_clusters").build();
        this.logId = InternalLogId.allocate("lrs-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    void startLoadReporting() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.started) {
            return;
        }
        this.started = true;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Starting load reporting RPC");
        this.startLrsRpc();
    }

    void stopLoadReporting() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (!this.started) {
            return;
        }
        this.started = false;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stopping load reporting RPC");
        if (this.lrsRpcRetryTimer != null && this.lrsRpcRetryTimer.isPending()) {
            this.lrsRpcRetryTimer.cancel();
        }
        if (this.lrsStream != null) {
            this.lrsStream.close(Status.CANCELLED.withDescription("stop load reporting").asException());
        }
    }

    private void startLrsRpc() {
        if (!this.started) {
            return;
        }
        Preconditions.checkState(this.lrsStream == null, "previous lbStream has not been cleared yet");
        this.lrsStream = new LrsStream();
        this.retryStopwatch.reset().start();
        Context prevContext = this.context.attach();
        try {
            this.lrsStream.start();
        }
        finally {
            this.context.detach(prevContext);
        }
    }

    private final class LrsStream {
        boolean initialResponseReceived;
        boolean closed;
        long intervalNano = -1L;
        boolean reportAllClusters;
        List<String> clusterNames;
        SynchronizationContext.ScheduledHandle loadReportTimer;
        StreamObserver<LoadStatsRequest> lrsRequestWriterV3;

        private LrsStream() {
        }

        void start() {
            StreamObserver<LoadStatsResponse> lrsResponseReaderV3 = new StreamObserver<LoadStatsResponse>(){

                @Override
                public void onNext(final LoadStatsResponse response) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LRS response:\n{0}", response);
                            LrsStream.this.handleRpcResponse(response.getClustersList(), response.getSendAllClusters(), Durations.toNanos(response.getLoadReportingInterval()));
                        }
                    });
                }

                @Override
                public void onError(final Throwable t) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStream.this.handleRpcError(t);
                        }
                    });
                }

                @Override
                public void onCompleted() {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStream.this.handleRpcCompleted();
                        }
                    });
                }
            };
            this.lrsRequestWriterV3 = ((LoadReportingServiceGrpc.LoadReportingServiceStub)LoadReportingServiceGrpc.newStub(LoadReportClient.this.channel).withWaitForReady()).streamLoadStats(lrsResponseReaderV3);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sending initial LRS request");
            this.sendLoadStatsRequest(Collections.emptyList());
        }

        void sendLoadStatsRequest(List<Stats.ClusterStats> clusterStatsList) {
            LoadStatsRequest.Builder requestBuilder = LoadStatsRequest.newBuilder().setNode(LoadReportClient.this.node.toEnvoyProtoNode());
            for (Stats.ClusterStats stats : clusterStatsList) {
                requestBuilder.addClusterStats(this.buildClusterStats(stats));
            }
            LoadStatsRequest request = requestBuilder.build();
            this.lrsRequestWriterV3.onNext(request);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent LoadStatsRequest\n{0}", request);
        }

        void sendError(Exception error) {
            this.lrsRequestWriterV3.onError(error);
        }

        void handleRpcResponse(List<String> clusters, boolean sendAllClusters, long loadReportIntervalNano) {
            if (this.closed) {
                return;
            }
            if (!this.initialResponseReceived) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Initial LRS response received");
                this.initialResponseReceived = true;
            }
            this.reportAllClusters = sendAllClusters;
            if (this.reportAllClusters) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for all clusters");
            } else {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for clusters: ", clusters);
                this.clusterNames = clusters;
            }
            this.intervalNano = loadReportIntervalNano;
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Update load reporting interval to {0} ns", this.intervalNano);
            this.scheduleNextLoadReport();
        }

        void handleRpcError(Throwable t) {
            this.handleStreamClosed(Status.fromThrowable(t));
        }

        void handleRpcCompleted() {
            this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
        }

        private void sendLoadReport() {
            ArrayList<Stats.ClusterStats> clusterStatsList;
            if (this.closed) {
                return;
            }
            if (this.reportAllClusters) {
                clusterStatsList = LoadReportClient.this.loadStatsManager.getAllClusterStatsReports();
            } else {
                clusterStatsList = new ArrayList();
                for (String name : this.clusterNames) {
                    clusterStatsList.addAll(LoadReportClient.this.loadStatsManager.getClusterStatsReports(name));
                }
            }
            this.sendLoadStatsRequest(clusterStatsList);
            this.scheduleNextLoadReport();
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportTimer != null && this.loadReportTimer.isPending()) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (this.intervalNano > 0L) {
                this.loadReportTimer = LoadReportClient.this.syncContext.schedule(new LoadReportingTask(this), this.intervalNano, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void handleStreamClosed(Status status) {
            Preconditions.checkArgument(!status.isOk(), "unexpected OK status");
            if (this.closed) {
                return;
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "LRS stream closed with status {0}: {1}. Cause: {2}", new Object[]{status.getCode(), status.getDescription(), status.getCause()});
            this.closed = true;
            this.cleanUp();
            if (this.initialResponseReceived || LoadReportClient.this.lrsRpcRetryPolicy == null) {
                LoadReportClient.this.lrsRpcRetryPolicy = LoadReportClient.this.backoffPolicyProvider.get();
            }
            long delayNanos = LoadReportClient.this.lrsRpcRetryPolicy.nextBackoffNanos() - LoadReportClient.this.retryStopwatch.elapsed(TimeUnit.NANOSECONDS);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry LRS stream in {0} ns", delayNanos);
            if (delayNanos <= 0L) {
                LoadReportClient.this.startLrsRpc();
            } else {
                LoadReportClient.this.lrsRpcRetryTimer = LoadReportClient.this.syncContext.schedule(new LrsRpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.sendError(error);
        }

        private void cleanUp() {
            if (this.loadReportTimer != null && this.loadReportTimer.isPending()) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (LoadReportClient.this.lrsStream == this) {
                LoadReportClient.this.lrsStream = null;
            }
        }

        private ClusterStats buildClusterStats(Stats.ClusterStats stats) {
            ClusterStats.Builder builder = ClusterStats.newBuilder().setClusterName(stats.clusterName());
            if (stats.clusterServiceName() != null) {
                builder.setClusterServiceName(stats.clusterServiceName());
            }
            for (Stats.UpstreamLocalityStats upstreamLocalityStats : stats.upstreamLocalityStatsList()) {
                builder.addUpstreamLocalityStats(UpstreamLocalityStats.newBuilder().setLocality(Locality.newBuilder().setRegion(upstreamLocalityStats.locality().region()).setZone(upstreamLocalityStats.locality().zone()).setSubZone(upstreamLocalityStats.locality().subZone())).setTotalSuccessfulRequests(upstreamLocalityStats.totalSuccessfulRequests()).setTotalErrorRequests(upstreamLocalityStats.totalErrorRequests()).setTotalRequestsInProgress(upstreamLocalityStats.totalRequestsInProgress()).setTotalIssuedRequests(upstreamLocalityStats.totalIssuedRequests()).addAllLoadMetricStats(upstreamLocalityStats.loadMetricStatsMap().entrySet().stream().map(e -> EndpointLoadMetricStats.newBuilder().setMetricName((String)e.getKey()).setNumRequestsFinishedWithMetric(((Stats.BackendLoadMetricStats)e.getValue()).numRequestsFinishedWithMetric()).setTotalMetricValue(((Stats.BackendLoadMetricStats)e.getValue()).totalMetricValue()).build()).collect(Collectors.toList())));
            }
            for (Stats.DroppedRequests droppedRequests : stats.droppedRequestsList()) {
                builder.addDroppedRequests(ClusterStats.DroppedRequests.newBuilder().setCategory(droppedRequests.category()).setDroppedCount(droppedRequests.droppedCount()));
            }
            return builder.setTotalDroppedRequests(stats.totalDroppedRequests()).setLoadReportInterval(Durations.fromNanos(stats.loadReportIntervalNano())).build();
        }
    }

    @VisibleForTesting
    class LrsRpcRetryTask
    implements Runnable {
        LrsRpcRetryTask() {
        }

        @Override
        public void run() {
            LoadReportClient.this.startLrsRpc();
        }
    }

    @VisibleForTesting
    static class LoadReportingTask
    implements Runnable {
        private final LrsStream stream;

        LoadReportingTask(LrsStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            this.stream.sendLoadReport();
        }
    }
}

