/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.census.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.opencensus.contrib.grpc.metrics.RpcMeasureConstants;
import com.google.bigtable.repackaged.io.opencensus.contrib.grpc.metrics.RpcViewConstants;
import com.google.bigtable.repackaged.io.opencensus.stats.Aggregation;
import com.google.bigtable.repackaged.io.opencensus.stats.Measure;
import com.google.bigtable.repackaged.io.opencensus.stats.View;
import com.google.bigtable.repackaged.io.opencensus.trace.SpanContext;
import java.util.Arrays;

@VisibleForTesting
public final class ObservabilityCensusConstants {
    public static CallOptions.Key<SpanContext> CLIENT_TRACE_SPAN_CONTEXT_KEY = CallOptions.Key.createWithDefault("Client span context for tracing", SpanContext.INVALID);
    static final Aggregation AGGREGATION_WITH_BYTES_HISTOGRAM = RpcViewConstants.GRPC_CLIENT_SENT_BYTES_PER_RPC_VIEW.getAggregation();
    static final Aggregation AGGREGATION_WITH_MILLIS_HISTOGRAM = RpcViewConstants.GRPC_CLIENT_ROUNDTRIP_LATENCY_VIEW.getAggregation();
    public static final Measure.MeasureDouble API_LATENCY_PER_CALL = Measure.MeasureDouble.create("grpc.io/client/api_latency", "Time taken by gRPC to complete an RPC from application's perspective", "ms");
    public static final View GRPC_CLIENT_API_LATENCY_VIEW = View.create(View.Name.create("grpc.io/client/api_latency"), "Time taken by gRPC to complete an RPC from application's perspective", API_LATENCY_PER_CALL, AGGREGATION_WITH_MILLIS_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_CLIENT_METHOD, RpcMeasureConstants.GRPC_CLIENT_STATUS));
    public static final View GRPC_CLIENT_SENT_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW = View.create(View.Name.create("grpc.io/client/sent_compressed_message_bytes_per_rpc"), "Compressed message bytes sent per client RPC attempt", RpcMeasureConstants.GRPC_CLIENT_SENT_BYTES_PER_RPC, AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_CLIENT_METHOD, RpcMeasureConstants.GRPC_CLIENT_STATUS));
    public static final View GRPC_CLIENT_RECEIVED_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW = View.create(View.Name.create("grpc.io/client/received_compressed_message_bytes_per_rpc"), "Compressed message bytes received per client RPC attempt", RpcMeasureConstants.GRPC_CLIENT_RECEIVED_BYTES_PER_RPC, AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_CLIENT_METHOD, RpcMeasureConstants.GRPC_CLIENT_STATUS));
    public static final View GRPC_SERVER_SENT_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW = View.create(View.Name.create("grpc.io/server/sent_compressed_message_bytes_per_rpc"), "Compressed message bytes sent per server RPC", RpcMeasureConstants.GRPC_SERVER_SENT_BYTES_PER_RPC, AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_SERVER_METHOD, RpcMeasureConstants.GRPC_SERVER_STATUS));
    public static final View GRPC_SERVER_RECEIVED_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW = View.create(View.Name.create("grpc.io/server/received_compressed_message_bytes_per_rpc"), "Compressed message bytes received per server RPC", RpcMeasureConstants.GRPC_SERVER_RECEIVED_BYTES_PER_RPC, AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_SERVER_METHOD, RpcMeasureConstants.GRPC_SERVER_STATUS));

    private ObservabilityCensusConstants() {
    }
}

