/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.trace.v1.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.GaxProperties;
import com.google.bigtable.repackaged.com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PageContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StubSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.TraceServiceClient;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.stub.GrpcTraceServiceStub;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.stub.HttpJsonTraceServiceStub;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.stub.TraceServiceStub;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.Trace;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class TraceServiceStubSettings
extends StubSettings<TraceServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/trace.append")).add("https://www.googleapis.com/auth/trace.readonly")).build();
    private final PagedCallSettings<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings;
    private final UnaryCallSettings<GetTraceRequest, Trace> getTraceSettings;
    private final UnaryCallSettings<PatchTracesRequest, Empty> patchTracesSettings;
    private static final PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace> LIST_TRACES_PAGE_STR_DESC = new PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListTracesRequest injectToken(ListTracesRequest payload, String token) {
            return ListTracesRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListTracesRequest injectPageSize(ListTracesRequest payload, int pageSize) {
            return ListTracesRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListTracesRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListTracesResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Trace> extractResources(ListTracesResponse payload) {
            return payload.getTracesList() == null ? ImmutableList.of() : payload.getTracesList();
        }
    };
    private static final PagedListResponseFactory<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> LIST_TRACES_PAGE_STR_FACT = new PagedListResponseFactory<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse>(){

        @Override
        public ApiFuture<TraceServiceClient.ListTracesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTracesRequest, ListTracesResponse> callable, ListTracesRequest request, ApiCallContext context, ApiFuture<ListTracesResponse> futureResponse) {
            PageContext<ListTracesRequest, ListTracesResponse, Trace> pageContext = PageContext.create(callable, LIST_TRACES_PAGE_STR_DESC, request, context);
            return TraceServiceClient.ListTracesPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings() {
        return this.listTracesSettings;
    }

    public UnaryCallSettings<GetTraceRequest, Trace> getTraceSettings() {
        return this.getTraceSettings;
    }

    public UnaryCallSettings<PatchTracesRequest, Empty> patchTracesSettings() {
        return this.patchTracesSettings;
    }

    public TraceServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTraceServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTraceServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudtrace.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudtrace.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TraceServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TraceServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TraceServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TraceServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TraceServiceStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.listTracesSettings = settingsBuilder.listTracesSettings().build();
        this.getTraceSettings = settingsBuilder.getTraceSettings().build();
        this.patchTracesSettings = settingsBuilder.patchTracesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TraceServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings;
        private final UnaryCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings;
        private final UnaryCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listTracesSettings = PagedCallSettings.newBuilder(LIST_TRACES_PAGE_STR_FACT);
            this.getTraceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchTracesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTracesSettings, this.getTraceSettings, this.patchTracesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TraceServiceStubSettings settings) {
            super(settings);
            this.listTracesSettings = settings.listTracesSettings.toBuilder();
            this.getTraceSettings = settings.getTraceSettings.toBuilder();
            this.patchTracesSettings = settings.patchTracesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTracesSettings, this.getTraceSettings, this.patchTracesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TraceServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(TraceServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(TraceServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TraceServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TraceServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TraceServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider(TraceServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(TraceServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TraceServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TraceServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            ((PagedCallSettings.Builder)builder.listTracesSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.getTraceSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.patchTracesSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings() {
            return this.listTracesSettings;
        }

        public UnaryCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings() {
            return this.getTraceSettings;
        }

        public UnaryCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings() {
            return this.patchTracesSettings;
        }

        public TraceServiceStubSettings build() throws IOException {
            return new TraceServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("retry_policy_0_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED)));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis(1000L)).setInitialRpcTimeout(Duration.ofMillis(45000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(45000L)).setTotalTimeout(Duration.ofMillis(45000L)).build();
            definitions.put("retry_policy_0_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

