/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.GaxProperties;
import com.google.bigtable.repackaged.com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StubSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableStub;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.GrpcBigtableStub;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

@InternalApi
public class BigtableStubSettings
extends StubSettings<BigtableStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/bigtable.data")).add("https://www.googleapis.com/auth/bigtable.data.readonly")).add("https://www.googleapis.com/auth/cloud-bigtable.data")).add("https://www.googleapis.com/auth/cloud-bigtable.data.readonly")).add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/cloud-platform.read-only")).build();
    private final ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> readRowsSettings;
    private final ServerStreamingCallSettings<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysSettings;
    private final UnaryCallSettings<MutateRowRequest, MutateRowResponse> mutateRowSettings;
    private final ServerStreamingCallSettings<MutateRowsRequest, MutateRowsResponse> mutateRowsSettings;
    private final UnaryCallSettings<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowSettings;
    private final UnaryCallSettings<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmSettings;
    private final UnaryCallSettings<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowSettings;
    private final ServerStreamingCallSettings<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> generateInitialChangeStreamPartitionsSettings;
    private final ServerStreamingCallSettings<ReadChangeStreamRequest, ReadChangeStreamResponse> readChangeStreamSettings;

    public ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> readRowsSettings() {
        return this.readRowsSettings;
    }

    public ServerStreamingCallSettings<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysSettings() {
        return this.sampleRowKeysSettings;
    }

    public UnaryCallSettings<MutateRowRequest, MutateRowResponse> mutateRowSettings() {
        return this.mutateRowSettings;
    }

    public ServerStreamingCallSettings<MutateRowsRequest, MutateRowsResponse> mutateRowsSettings() {
        return this.mutateRowsSettings;
    }

    public UnaryCallSettings<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowSettings() {
        return this.checkAndMutateRowSettings;
    }

    public UnaryCallSettings<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmSettings() {
        return this.pingAndWarmSettings;
    }

    public UnaryCallSettings<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowSettings() {
        return this.readModifyWriteRowSettings;
    }

    public ServerStreamingCallSettings<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> generateInitialChangeStreamPartitionsSettings() {
        return this.generateInitialChangeStreamPartitionsSettings;
    }

    public ServerStreamingCallSettings<ReadChangeStreamRequest, ReadChangeStreamResponse> readChangeStreamSettings() {
        return this.readChangeStreamSettings;
    }

    public BigtableStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBigtableStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "bigtable.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigtable.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BigtableStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BigtableStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BigtableStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.readRowsSettings = settingsBuilder.readRowsSettings().build();
        this.sampleRowKeysSettings = settingsBuilder.sampleRowKeysSettings().build();
        this.mutateRowSettings = settingsBuilder.mutateRowSettings().build();
        this.mutateRowsSettings = settingsBuilder.mutateRowsSettings().build();
        this.checkAndMutateRowSettings = settingsBuilder.checkAndMutateRowSettings().build();
        this.pingAndWarmSettings = settingsBuilder.pingAndWarmSettings().build();
        this.readModifyWriteRowSettings = settingsBuilder.readModifyWriteRowSettings().build();
        this.generateInitialChangeStreamPartitionsSettings = settingsBuilder.generateInitialChangeStreamPartitionsSettings().build();
        this.readChangeStreamSettings = settingsBuilder.readChangeStreamSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BigtableStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final ServerStreamingCallSettings.Builder<ReadRowsRequest, ReadRowsResponse> readRowsSettings;
        private final ServerStreamingCallSettings.Builder<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysSettings;
        private final UnaryCallSettings.Builder<MutateRowRequest, MutateRowResponse> mutateRowSettings;
        private final ServerStreamingCallSettings.Builder<MutateRowsRequest, MutateRowsResponse> mutateRowsSettings;
        private final UnaryCallSettings.Builder<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowSettings;
        private final UnaryCallSettings.Builder<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmSettings;
        private final UnaryCallSettings.Builder<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowSettings;
        private final ServerStreamingCallSettings.Builder<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> generateInitialChangeStreamPartitionsSettings;
        private final ServerStreamingCallSettings.Builder<ReadChangeStreamRequest, ReadChangeStreamResponse> readChangeStreamSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.readRowsSettings = ServerStreamingCallSettings.newBuilder();
            this.sampleRowKeysSettings = ServerStreamingCallSettings.newBuilder();
            this.mutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.mutateRowsSettings = ServerStreamingCallSettings.newBuilder();
            this.checkAndMutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pingAndWarmSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readModifyWriteRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateInitialChangeStreamPartitionsSettings = ServerStreamingCallSettings.newBuilder();
            this.readChangeStreamSettings = ServerStreamingCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.mutateRowSettings, this.checkAndMutateRowSettings, this.pingAndWarmSettings, this.readModifyWriteRowSettings);
            Builder.initDefaults(this);
        }

        protected Builder(BigtableStubSettings settings) {
            super(settings);
            this.readRowsSettings = settings.readRowsSettings.toBuilder();
            this.sampleRowKeysSettings = settings.sampleRowKeysSettings.toBuilder();
            this.mutateRowSettings = settings.mutateRowSettings.toBuilder();
            this.mutateRowsSettings = settings.mutateRowsSettings.toBuilder();
            this.checkAndMutateRowSettings = settings.checkAndMutateRowSettings.toBuilder();
            this.pingAndWarmSettings = settings.pingAndWarmSettings.toBuilder();
            this.readModifyWriteRowSettings = settings.readModifyWriteRowSettings.toBuilder();
            this.generateInitialChangeStreamPartitionsSettings = settings.generateInitialChangeStreamPartitionsSettings.toBuilder();
            this.readChangeStreamSettings = settings.readChangeStreamSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.mutateRowSettings, this.checkAndMutateRowSettings, this.pingAndWarmSettings, this.readModifyWriteRowSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BigtableStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(BigtableStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(BigtableStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BigtableStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(BigtableStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.readRowsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_3_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_3_params"));
            builder.sampleRowKeysSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_1_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_1_params"));
            builder.mutateRowSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_4_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_4_params"));
            builder.mutateRowsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_2_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_2_params"));
            builder.checkAndMutateRowSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_0_params"));
            builder.pingAndWarmSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.readModifyWriteRowSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_0_params"));
            builder.generateInitialChangeStreamPartitionsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_5_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_5_params"));
            builder.readChangeStreamSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_6_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_6_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public ServerStreamingCallSettings.Builder<ReadRowsRequest, ReadRowsResponse> readRowsSettings() {
            return this.readRowsSettings;
        }

        public ServerStreamingCallSettings.Builder<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysSettings() {
            return this.sampleRowKeysSettings;
        }

        public UnaryCallSettings.Builder<MutateRowRequest, MutateRowResponse> mutateRowSettings() {
            return this.mutateRowSettings;
        }

        public ServerStreamingCallSettings.Builder<MutateRowsRequest, MutateRowsResponse> mutateRowsSettings() {
            return this.mutateRowsSettings;
        }

        public UnaryCallSettings.Builder<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowSettings() {
            return this.checkAndMutateRowSettings;
        }

        public UnaryCallSettings.Builder<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmSettings() {
            return this.pingAndWarmSettings;
        }

        public UnaryCallSettings.Builder<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowSettings() {
            return this.readModifyWriteRowSettings;
        }

        public ServerStreamingCallSettings.Builder<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> generateInitialChangeStreamPartitionsSettings() {
            return this.generateInitialChangeStreamPartitionsSettings;
        }

        public ServerStreamingCallSettings.Builder<ReadChangeStreamRequest, ReadChangeStreamResponse> readChangeStreamSettings() {
            return this.readChangeStreamSettings;
        }

        public BigtableStubSettings build() throws IOException {
            return new BigtableStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("no_retry_3_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("no_retry_1_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("retry_policy_4_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED)));
            definitions.put("no_retry_2_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("no_retry_0_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("no_retry_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("no_retry_5_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("no_retry_6_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis(43200000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(43200000L)).setTotalTimeout(Duration.ofMillis(43200000L)).build();
            definitions.put("no_retry_3_params", settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(60000L)).setTotalTimeout(Duration.ofMillis(60000L)).build();
            definitions.put("no_retry_1_params", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(60000L)).setTotalTimeout(Duration.ofMillis(60000L)).build();
            definitions.put("retry_policy_4_params", settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(600000L)).setTotalTimeout(Duration.ofMillis(600000L)).build();
            definitions.put("no_retry_2_params", settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis(20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(20000L)).setTotalTimeout(Duration.ofMillis(20000L)).build();
            definitions.put("no_retry_0_params", settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put("no_retry_params", settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(60000L)).setTotalTimeout(Duration.ofMillis(60000L)).build();
            definitions.put("no_retry_5_params", settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis(43200000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(43200000L)).setTotalTimeout(Duration.ofMillis(43200000L)).build();
            definitions.put("no_retry_6_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

