/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CopyBackupRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.util.Timestamps;
import com.google.bigtable.repackaged.org.threeten.bp.Instant;
import javax.annotation.Nonnull;

public final class CopyBackupRequest {
    private final CopyBackupRequest.Builder requestBuilder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CopyBackupRequest.newBuilder();
    private final String sourceBackupId;
    private final String sourceClusterId;
    private String sourceInstanceId;
    private String sourceProjectId;
    private String destClusterId;

    public static CopyBackupRequest of(String sourceClusterId, String sourceBackupId) {
        CopyBackupRequest request = new CopyBackupRequest(sourceClusterId, sourceBackupId);
        return request;
    }

    private CopyBackupRequest(@Nonnull String sourceClusterId, @Nonnull String sourceBackupId) {
        Preconditions.checkNotNull(sourceClusterId);
        Preconditions.checkNotNull(sourceBackupId);
        this.sourceClusterId = sourceClusterId;
        this.sourceBackupId = sourceBackupId;
    }

    public CopyBackupRequest setSourceInstance(String instanceId) {
        Preconditions.checkNotNull(instanceId);
        this.sourceInstanceId = instanceId;
        return this;
    }

    public CopyBackupRequest setSourceInstance(String projectId, String instanceId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(instanceId);
        this.sourceProjectId = projectId;
        this.sourceInstanceId = instanceId;
        return this;
    }

    public CopyBackupRequest setDestination(String clusterId, String backupId) {
        Preconditions.checkNotNull(backupId);
        Preconditions.checkNotNull(clusterId);
        this.requestBuilder.setBackupId(backupId);
        this.destClusterId = clusterId;
        return this;
    }

    public CopyBackupRequest setExpireTime(Instant expireTime) {
        Preconditions.checkNotNull(expireTime);
        this.requestBuilder.setExpireTime(Timestamps.fromMillis(expireTime.toEpochMilli()));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyBackupRequest that = (CopyBackupRequest)o;
        return Objects.equal(this.requestBuilder.getBackupId(), that.requestBuilder.getBackupId()) && Objects.equal(this.sourceBackupId, that.sourceBackupId) && Objects.equal(this.sourceClusterId, that.sourceClusterId) && Objects.equal(this.sourceInstanceId, that.sourceInstanceId) && Objects.equal(this.sourceProjectId, that.sourceProjectId);
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.getBackupId(), this.sourceBackupId, this.sourceClusterId, this.sourceInstanceId, this.sourceProjectId);
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CopyBackupRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(instanceId);
        return this.requestBuilder.setParent(NameUtil.formatClusterName(projectId, instanceId, this.destClusterId)).setSourceBackup(NameUtil.formatBackupName(this.sourceProjectId == null ? projectId : this.sourceProjectId, this.sourceInstanceId == null ? instanceId : this.sourceInstanceId, this.sourceClusterId, this.sourceBackupId)).build();
    }
}

