/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.implcore.trace;

import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.common.Clock;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.implcore.internal.TimestampConverter;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.implcore.trace.NoRecordEventsSpanImpl;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.implcore.trace.RecordEventsSpanImpl;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.implcore.trace.internal.RandomHandler;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.Link;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.Sampler;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.Span;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.SpanBuilder;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.SpanContext;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.SpanId;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.TraceId;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.TraceOptions;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.Tracestate;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.config.TraceConfig;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.config.TraceParams;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

final class SpanBuilderImpl
extends SpanBuilder {
    private static final Tracestate TRACESTATE_DEFAULT = Tracestate.builder().build();
    private static final TraceOptions SAMPLED_TRACE_OPTIONS = TraceOptions.builder().setIsSampled(true).build();
    private static final TraceOptions NOT_SAMPLED_TRACE_OPTIONS = TraceOptions.builder().setIsSampled(false).build();
    private final Options options;
    private final String name;
    @Nullable
    private final Span parent;
    @Nullable
    private final SpanContext remoteParentSpanContext;
    @Nullable
    private Sampler sampler;
    private List<Span> parentLinks = Collections.emptyList();
    @Nullable
    private Boolean recordEvents;
    @Nullable
    private Span.Kind kind;

    private Span startSpanInternal(@Nullable SpanContext parentContext, @Nullable Boolean hasRemoteParent, String name, @Nullable Sampler sampler, List<Span> parentLinks, @Nullable Boolean recordEvents, @Nullable Span.Kind kind, @Nullable Span parentSpan) {
        TraceOptions traceOptions;
        TraceId traceId;
        TraceParams activeTraceParams = this.options.traceConfig.getActiveTraceParams();
        Random random = this.options.randomHandler.current();
        SpanId spanId = SpanId.generateRandomId(random);
        SpanId parentSpanId = null;
        Tracestate tracestate = TRACESTATE_DEFAULT;
        if (parentContext == null || !parentContext.isValid()) {
            traceId = TraceId.generateRandomId(random);
            hasRemoteParent = null;
        } else {
            traceId = parentContext.getTraceId();
            parentSpanId = parentContext.getSpanId();
            tracestate = parentContext.getTracestate();
        }
        TraceOptions traceOptions2 = traceOptions = SpanBuilderImpl.makeSamplingDecision(parentContext, hasRemoteParent, name, sampler, parentLinks, traceId, spanId, activeTraceParams) ? SAMPLED_TRACE_OPTIONS : NOT_SAMPLED_TRACE_OPTIONS;
        if (traceOptions.isSampled() || Boolean.TRUE.equals(recordEvents)) {
            TimestampConverter timestampConverter = null;
            if (parentSpan instanceof RecordEventsSpanImpl) {
                RecordEventsSpanImpl parentRecordEventsSpan = (RecordEventsSpanImpl)parentSpan;
                timestampConverter = parentRecordEventsSpan.getTimestampConverter();
                parentRecordEventsSpan.addChild();
            }
            RecordEventsSpanImpl span = RecordEventsSpanImpl.startSpan(SpanContext.create(traceId, spanId, traceOptions, tracestate), name, kind, parentSpanId, hasRemoteParent, activeTraceParams, this.options.startEndHandler, timestampConverter, this.options.clock);
            SpanBuilderImpl.linkSpans(span, parentLinks);
            return span;
        }
        return NoRecordEventsSpanImpl.create(SpanContext.create(traceId, spanId, traceOptions, tracestate));
    }

    private static boolean makeSamplingDecision(@Nullable SpanContext parent, @Nullable Boolean hasRemoteParent, String name, @Nullable Sampler sampler, List<Span> parentLinks, TraceId traceId, SpanId spanId, TraceParams activeTraceParams) {
        if (sampler != null) {
            return sampler.shouldSample(parent, hasRemoteParent, traceId, spanId, name, parentLinks);
        }
        if (Boolean.TRUE.equals(hasRemoteParent) || parent == null || !parent.isValid()) {
            return activeTraceParams.getSampler().shouldSample(parent, hasRemoteParent, traceId, spanId, name, parentLinks);
        }
        return parent.getTraceOptions().isSampled() || SpanBuilderImpl.isAnyParentLinkSampled(parentLinks);
    }

    private static boolean isAnyParentLinkSampled(List<Span> parentLinks) {
        for (Span parentLink : parentLinks) {
            if (!parentLink.getContext().getTraceOptions().isSampled()) continue;
            return true;
        }
        return false;
    }

    private static void linkSpans(Span span, List<Span> parentLinks) {
        if (!parentLinks.isEmpty()) {
            Link childLink = Link.fromSpanContext(span.getContext(), Link.Type.CHILD_LINKED_SPAN);
            for (Span linkedSpan : parentLinks) {
                linkedSpan.addLink(childLink);
                span.addLink(Link.fromSpanContext(linkedSpan.getContext(), Link.Type.PARENT_LINKED_SPAN));
            }
        }
    }

    static SpanBuilderImpl createWithParent(String spanName, @Nullable Span parent, Options options) {
        return new SpanBuilderImpl(spanName, null, parent, options);
    }

    static SpanBuilderImpl createWithRemoteParent(String spanName, @Nullable SpanContext remoteParentSpanContext, Options options) {
        return new SpanBuilderImpl(spanName, remoteParentSpanContext, null, options);
    }

    private SpanBuilderImpl(String name, @Nullable SpanContext remoteParentSpanContext, @Nullable Span parent, Options options) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.parent = parent;
        this.remoteParentSpanContext = remoteParentSpanContext;
        this.options = options;
    }

    @Override
    public Span startSpan() {
        if (this.remoteParentSpanContext != null) {
            return this.startSpanInternal(this.remoteParentSpanContext, Boolean.TRUE, this.name, this.sampler, this.parentLinks, this.recordEvents, this.kind, null);
        }
        SpanContext parentContext = null;
        Boolean hasRemoteParent = null;
        if (this.parent != null) {
            parentContext = this.parent.getContext();
            hasRemoteParent = Boolean.FALSE;
        }
        return this.startSpanInternal(parentContext, hasRemoteParent, this.name, this.sampler, this.parentLinks, this.recordEvents, this.kind, this.parent);
    }

    @Override
    public SpanBuilderImpl setSampler(Sampler sampler) {
        this.sampler = Preconditions.checkNotNull(sampler, "sampler");
        return this;
    }

    @Override
    public SpanBuilderImpl setParentLinks(List<Span> parentLinks) {
        this.parentLinks = Preconditions.checkNotNull(parentLinks, "parentLinks");
        return this;
    }

    @Override
    public SpanBuilderImpl setRecordEvents(boolean recordEvents) {
        this.recordEvents = recordEvents;
        return this;
    }

    @Override
    public SpanBuilderImpl setSpanKind(@Nullable Span.Kind kind) {
        this.kind = kind;
        return this;
    }

    static final class Options {
        private final RandomHandler randomHandler;
        private final RecordEventsSpanImpl.StartEndHandler startEndHandler;
        private final Clock clock;
        private final TraceConfig traceConfig;

        Options(RandomHandler randomHandler, RecordEventsSpanImpl.StartEndHandler startEndHandler, Clock clock, TraceConfig traceConfig) {
            this.randomHandler = Preconditions.checkNotNull(randomHandler, "randomHandler");
            this.startEndHandler = Preconditions.checkNotNull(startEndHandler, "startEndHandler");
            this.clock = Preconditions.checkNotNull(clock, "clock");
            this.traceConfig = Preconditions.checkNotNull(traceConfig, "traceConfig");
        }
    }
}

