/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.bigtable.admin.v2;

import com.google.bigtable.repackaged.com.google.api.pathtemplate.PathTemplate;
import com.google.bigtable.repackaged.com.google.api.resourcenames.ResourceName;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InstanceName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE = PathTemplate.createWithoutUrlEncoding("projects/{project}/instances/{instance}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;

    @Deprecated
    protected InstanceName() {
        this.project = null;
        this.instance = null;
    }

    private InstanceName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.instance = Preconditions.checkNotNull(builder.getInstance());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InstanceName of(String project, String instance) {
        return InstanceName.newBuilder().setProject(project).setInstance(instance).build();
    }

    public static String format(String project, String instance) {
        return InstanceName.newBuilder().setProject(project).setInstance(instance).build().toString();
    }

    public static InstanceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_INSTANCE.validatedMatch(formattedString, "InstanceName.parse: formattedString not in valid format");
        return InstanceName.of(matchMap.get("project"), matchMap.get("instance"));
    }

    public static List<InstanceName> parseList(List<String> formattedStrings) {
        ArrayList<InstanceName> list = new ArrayList<InstanceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstanceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstanceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstanceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstanceName instanceName = this;
            synchronized (instanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put("instance", this.instance);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE.instantiate("project", this.project, "instance", this.instance);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InstanceName that = (InstanceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.instance);
    }

    public static class Builder {
        private String project;
        private String instance;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        private Builder(InstanceName instanceName) {
            this.project = instanceName.project;
            this.instance = instanceName.instance;
        }

        public InstanceName build() {
            return new InstanceName(this);
        }
    }
}

