/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.util.AutoValue_CredentialOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RedactedString;
import javax.annotation.Nullable;

@AutoValue
public abstract class CredentialOptions {
    static final boolean SERVICE_ACCOUNT_ENABLED_DEFAULT = true;
    static final boolean NULL_CREDENTIALS_ENABLED_DEFAULT = false;
    static final HttpTransportFactory.HttpTransportType HTTP_TRANSPORT_TYPE_DEFAULT = HttpTransportFactory.DEFAULT_TRANSPORT_TYPE;
    static final String TOKEN_SERVER_URL_DEFAULT = "https://oauth2.googleapis.com/token";

    public static Builder builder() {
        return new AutoValue_CredentialOptions.Builder().setServiceAccountEnabled(true).setNullCredentialEnabled(false).setTransportType(HTTP_TRANSPORT_TYPE_DEFAULT).setTokenServerUrl(TOKEN_SERVER_URL_DEFAULT);
    }

    public abstract boolean isServiceAccountEnabled();

    @Nullable
    public abstract RedactedString getServiceAccountPrivateKeyId();

    @Nullable
    public abstract RedactedString getServiceAccountPrivateKey();

    @Nullable
    public abstract String getServiceAccountEmail();

    @Nullable
    public abstract String getServiceAccountKeyFile();

    @Nullable
    public abstract String getServiceAccountJsonKeyFile();

    @Nullable
    public abstract RedactedString getClientId();

    @Nullable
    public abstract RedactedString getClientSecret();

    @Nullable
    public abstract String getOAuthCredentialFile();

    public abstract boolean isNullCredentialEnabled();

    public abstract HttpTransportFactory.HttpTransportType getTransportType();

    public abstract String getTokenServerUrl();

    @Nullable
    public abstract String getProxyAddress();

    @Nullable
    public abstract RedactedString getProxyUsername();

    @Nullable
    public abstract RedactedString getProxyPassword();

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setServiceAccountEnabled(boolean var1);

        public abstract Builder setServiceAccountPrivateKeyId(RedactedString var1);

        public abstract Builder setServiceAccountPrivateKey(RedactedString var1);

        public abstract Builder setServiceAccountEmail(String var1);

        public abstract Builder setServiceAccountKeyFile(String var1);

        public abstract Builder setServiceAccountJsonKeyFile(String var1);

        public abstract Builder setClientId(RedactedString var1);

        public abstract Builder setClientSecret(RedactedString var1);

        public abstract Builder setOAuthCredentialFile(String var1);

        public abstract Builder setNullCredentialEnabled(boolean var1);

        public abstract Builder setTransportType(HttpTransportFactory.HttpTransportType var1);

        public abstract Builder setTokenServerUrl(String var1);

        public abstract Builder setProxyAddress(String var1);

        public abstract Builder setProxyUsername(RedactedString var1);

        public abstract Builder setProxyPassword(RedactedString var1);

        public abstract CredentialOptions build();
    }
}

