/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class BaseAbstractGoogleAsyncWriteChannel<T>
implements WritableByteChannel {
    protected static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final int GCS_UPLOAD_GRANULARITY = 0x800000;
    public static final int UPLOAD_CHUNK_SIZE_DEFAULT = Runtime.getRuntime().maxMemory() < 0x20000000L ? 0x800000 : 0x4000000;
    @Deprecated
    public static final int UPLOAD_PIPE_BUFFER_SIZE_DEFAULT = 0x100000;
    protected String contentType;
    protected final ExecutorService threadPool;
    private boolean initialized = false;
    private final int pipeBufferSize;
    private final AsyncWriteChannelOptions.PipeType pipeType;
    protected int uploadChunkSize = UPLOAD_CHUNK_SIZE_DEFAULT;
    private WritableByteChannel pipeSink;
    protected Future<T> uploadOperation;
    private boolean directUploadEnabled = false;
    private ByteBuffer uploadCache = null;

    public BaseAbstractGoogleAsyncWriteChannel(ExecutorService threadPool, AsyncWriteChannelOptions options) {
        this.threadPool = threadPool;
        this.pipeBufferSize = options.getPipeBufferSize();
        this.pipeType = options.getPipeType();
        if (options.getUploadCacheSize() > 0) {
            this.uploadCache = ByteBuffer.allocate(options.getUploadCacheSize());
        }
        this.setUploadChunkSize(options.getUploadChunkSize());
        this.setDirectUploadEnabled(options.isDirectUploadEnabled());
        this.setContentType("application/octet-stream");
    }

    public abstract void startUpload(InputStream var1) throws IOException;

    public void handleResponse(T response) throws IOException {
    }

    public T createResponseFromException(IOException ioe) {
        return null;
    }

    @Deprecated
    public void setUploadBufferSize(int bufferSize) {
        this.setUploadChunkSize(bufferSize);
    }

    public abstract void setUploadChunkSize(int var1);

    public void setDirectUploadEnabled(boolean enableDirectUpload) {
        this.directUploadEnabled = enableDirectUpload;
    }

    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    @Override
    public synchronized int write(ByteBuffer buffer) throws IOException {
        Preconditions.checkState((boolean)this.initialized, (Object)"initialize() must be invoked before use.");
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.uploadOperation.isDone()) {
            this.waitForCompletionAndThrowIfUploadFailed();
        }
        if (this.uploadCache != null && this.uploadCache.remaining() >= buffer.remaining()) {
            int position = buffer.position();
            this.uploadCache.put(buffer);
            buffer.position(position);
        } else {
            this.uploadCache = null;
        }
        try {
            return this.pipeSink.write(buffer);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to write %d bytes in '%s'", buffer.remaining(), this.getResourceString()), e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.pipeSink != null && this.pipeSink.isOpen();
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((boolean)this.initialized, (Object)"initialize() must be invoked before use.");
        if (!this.isOpen()) {
            return;
        }
        try {
            this.pipeSink.close();
            this.handleResponse(this.waitForCompletionAndThrowIfUploadFailed());
        }
        catch (IOException e) {
            if (this.uploadCache == null) {
                throw e;
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Reuploading using cached data");
            this.reuploadFromCache();
        }
        finally {
            this.closeInternal();
        }
    }

    private void reuploadFromCache() throws IOException {
        this.closeInternal();
        this.initialized = false;
        this.initialize();
        ByteBuffer reuploadData = this.uploadCache;
        this.uploadCache = null;
        reuploadData.flip();
        try {
            this.write(reuploadData);
        }
        finally {
            this.close();
        }
    }

    private void closeInternal() {
        this.pipeSink = null;
        if (this.uploadOperation != null && !this.uploadOperation.isDone()) {
            this.uploadOperation.cancel(true);
        }
        this.uploadOperation = null;
    }

    public void initialize() throws IOException {
        InputStream pipeSource = this.initializeUploadPipe();
        this.startUpload(pipeSource);
        this.initialized = true;
    }

    private InputStream initializeUploadPipe() throws IOException {
        switch (this.pipeType) {
            case NIO_CHANNEL_PIPE: {
                Pipe pipe = Pipe.open();
                this.pipeSink = pipe.sink();
                InputStream pipeSource = Channels.newInputStream(pipe.source());
                return this.pipeBufferSize > 0 ? new BufferedInputStream(pipeSource, this.pipeBufferSize) : pipeSource;
            }
            case IO_STREAM_PIPE: {
                PipedInputStream internalPipeSource = new PipedInputStream(this.pipeBufferSize);
                PipedOutputStream internalPipeSink = new PipedOutputStream(internalPipeSource);
                this.pipeSink = Channels.newChannel(internalPipeSink);
                return internalPipeSource;
            }
        }
        throw new IllegalStateException("Unknown PipeType: " + (Object)((Object)this.pipeType));
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected abstract String getResourceString();

    private T waitForCompletionAndThrowIfUploadFailed() throws IOException {
        try {
            return this.uploadOperation.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.uploadOperation.cancel(true);
            ClosedByInterruptException exception = new ClosedByInterruptException();
            exception.addSuppressed(e);
            throw exception;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new IOException(String.format("Upload failed for '%s'", this.getResourceString()), e.getCause());
        }
    }
}

