/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHttpInitializer
implements HttpRequestInitializer {
    public static final int STATUS_CODE_TOO_MANY_REQUESTS = 429;
    private static final Logger LOG = LoggerFactory.getLogger(RetryHttpInitializer.class);
    private static final HttpBackOffUnsuccessfulResponseHandler.BackOffRequired BASE_HTTP_BACKOFF_REQUIRED = HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ON_SERVER_ERROR;
    private static final int DEFAULT_MAX_REQUEST_RETRIES = 10;
    private static final int DEFAULT_CONNECT_TIMEOUT = 20000;
    private static final int DEFAULT_READ_TIMEOUT = 20000;
    private final Credential credential;
    private Sleeper sleeperOverride;
    private String defaultUserAgent;
    private final int maxRequestRetries;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;

    public RetryHttpInitializer(Credential credential, String defaultUserAgent, int maxRequestRetries, int connectTimeoutMillis, int readTimeoutMillis) {
        Preconditions.checkNotNull((Object)credential, (Object)"A valid Credential is required");
        this.credential = credential;
        this.sleeperOverride = null;
        this.defaultUserAgent = defaultUserAgent;
        this.maxRequestRetries = maxRequestRetries;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public RetryHttpInitializer(Credential credential, String defaultUserAgent) {
        this(credential, defaultUserAgent, 10, 20000, 20000);
    }

    public void initialize(HttpRequest request) {
        request.setInterceptor((HttpExecuteInterceptor)this.credential);
        request.setNumberOfRetries(this.maxRequestRetries);
        request.setConnectTimeout(this.connectTimeoutMillis);
        request.setReadTimeout(this.readTimeoutMillis);
        HttpBackOffIOExceptionHandler exceptionHandler = new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff());
        if (this.sleeperOverride != null) {
            exceptionHandler.setSleeper(this.sleeperOverride);
        }
        LoggingResponseHandler loggingResponseHandler = new LoggingResponseHandler(new CredentialOrBackoffResponseHandler(), (HttpIOExceptionHandler)exceptionHandler, (Set<Integer>)ImmutableSet.of((Object)410, (Object)503));
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)loggingResponseHandler);
        request.setIOExceptionHandler((HttpIOExceptionHandler)loggingResponseHandler);
        if (Strings.isNullOrEmpty((String)request.getHeaders().getUserAgent())) {
            LOG.trace("Request is missing a user-agent, adding default value of '{}'", (Object)this.defaultUserAgent);
            request.getHeaders().setUserAgent(this.defaultUserAgent);
        }
    }

    @VisibleForTesting
    void setSleeperOverride(Sleeper sleeper) {
        this.sleeperOverride = sleeper;
    }

    private class CredentialOrBackoffResponseHandler
    implements HttpUnsuccessfulResponseHandler {
        private final HttpUnsuccessfulResponseHandler delegateHandler;

        public CredentialOrBackoffResponseHandler() {
            HttpBackOffUnsuccessfulResponseHandler errorCodeHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff());
            errorCodeHandler.setBackOffRequired(new HttpBackOffUnsuccessfulResponseHandler.BackOffRequired(){

                public boolean isRequired(HttpResponse response) {
                    return BASE_HTTP_BACKOFF_REQUIRED.isRequired(response) || response.getStatusCode() == 429;
                }
            });
            if (RetryHttpInitializer.this.sleeperOverride != null) {
                errorCodeHandler.setSleeper(RetryHttpInitializer.this.sleeperOverride);
            }
            this.delegateHandler = errorCodeHandler;
        }

        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
            String redirectLocation;
            if (RetryHttpInitializer.this.credential.handleResponse(request, response, supportsRetry)) {
                return true;
            }
            if (this.delegateHandler.handleResponse(request, response, supportsRetry)) {
                return true;
            }
            if (HttpStatusCodes.isRedirect((int)response.getStatusCode()) && request.getFollowRedirects() && response.getHeaders() != null && response.getHeaders().getLocation() != null && (redirectLocation = response.getHeaders().getLocation()).contains("+")) {
                String escapedLocation = redirectLocation.replace("+", "%2B");
                LOG.debug("Redirect path '{}' contains unescaped '+', replacing with '%2B': '{}'", (Object)redirectLocation, (Object)escapedLocation);
                response.getHeaders().setLocation(escapedLocation);
            }
            return false;
        }
    }

    private static class LoggingResponseHandler
    implements HttpUnsuccessfulResponseHandler,
    HttpIOExceptionHandler {
        private final HttpUnsuccessfulResponseHandler delegateResponseHandler;
        private final HttpIOExceptionHandler delegateIOExceptionHandler;
        private final ImmutableSet<Integer> responseCodesToLog;

        public LoggingResponseHandler(HttpUnsuccessfulResponseHandler delegateResponseHandler, HttpIOExceptionHandler delegateIOExceptionHandler, Set<Integer> responseCodesToLog) {
            this.delegateResponseHandler = delegateResponseHandler;
            this.delegateIOExceptionHandler = delegateIOExceptionHandler;
            this.responseCodesToLog = ImmutableSet.copyOf(responseCodesToLog);
        }

        public boolean handleResponse(HttpRequest httpRequest, HttpResponse httpResponse, boolean supportsRetry) throws IOException {
            if (this.responseCodesToLog.contains((Object)httpResponse.getStatusCode())) {
                LOG.info("Encountered status code {} when accessing URL {}. Delegating to response handler for possible retry.", (Object)httpResponse.getStatusCode(), (Object)httpRequest.getUrl());
            }
            return this.delegateResponseHandler.handleResponse(httpRequest, httpResponse, supportsRetry);
        }

        public boolean handleIOException(HttpRequest httpRequest, boolean supportsRetry) throws IOException {
            LOG.debug("Encountered an IOException when accessing URL {}", (Object)httpRequest.getUrl());
            return this.delegateIOExceptionHandler.handleIOException(httpRequest, supportsRetry);
        }
    }
}

