/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.CredentialConfiguration;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class EntriesCredentialConfiguration
extends CredentialConfiguration {
    public static final String BASE_KEY_PREFIX = "google.cloud";
    public static final String ENABLE_SERVICE_ACCOUNTS_SUFFIX = ".auth.service.account.enable";
    public static final String SERVICE_ACCOUNT_EMAIL_SUFFIX = ".auth.service.account.email";
    public static final String SERVICE_ACCOUNT_KEYFILE_SUFFIX = ".auth.service.account.keyfile";
    public static final String JSON_KEYFILE_SUFFIX = ".auth.service.account.json.keyfile";
    public static final String CLIENT_ID_SUFFIX = ".auth.client.id";
    public static final String CLIENT_SECRET_SUFFIX = ".auth.client.secret";
    public static final String OAUTH_CLIENT_FILE_SUFFIX = ".auth.client.file";
    public static final String ENABLE_NULL_CREDENTIAL_SUFFIX = ".auth.null.enable";
    private final List<String> prefixes;

    public static EntriesBuilder newEntriesBuilder() {
        return new EntriesBuilder();
    }

    private static Optional<Boolean> maybeGetBoolean(Entries config, String key) {
        String value = config.get(key);
        if (value == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Boolean.valueOf(value));
    }

    public EntriesCredentialConfiguration(List<String> prefixes) {
        this.prefixes = ImmutableList.copyOf(prefixes);
    }

    public void getConfigurationInto(Entries configuration) {
        for (String prefix : this.prefixes) {
            configuration.setBoolean(prefix + ENABLE_SERVICE_ACCOUNTS_SUFFIX, this.isServiceAccountEnabled());
            if (this.getServiceAccountEmail() != null) {
                configuration.set(prefix + SERVICE_ACCOUNT_EMAIL_SUFFIX, this.getServiceAccountEmail());
            }
            if (this.getServiceAccountKeyFile() != null) {
                configuration.set(prefix + SERVICE_ACCOUNT_KEYFILE_SUFFIX, this.getServiceAccountKeyFile());
            }
            if (this.getServiceAccountJsonKeyFile() != null) {
                configuration.set(prefix + JSON_KEYFILE_SUFFIX, this.getServiceAccountJsonKeyFile());
            }
            if (this.getClientId() != null) {
                configuration.set(prefix + CLIENT_ID_SUFFIX, this.getClientId());
            }
            if (this.getClientSecret() != null) {
                configuration.set(prefix + CLIENT_SECRET_SUFFIX, this.getClientSecret());
            }
            if (this.getOAuthCredentialFile() != null) {
                configuration.set(prefix + OAUTH_CLIENT_FILE_SUFFIX, this.getOAuthCredentialFile());
            }
            configuration.setBoolean(prefix + ENABLE_NULL_CREDENTIAL_SUFFIX, this.isNullCredentialEnabled());
        }
    }

    public void setConfiguration(Entries entries) {
        for (String prefix : this.prefixes) {
            Optional<Boolean> enableNullCredential;
            String oAuthCredentialPath;
            String clientSecret;
            String clientId;
            String serviceAccountJsonKeyFile;
            String serviceAccountKeyFile;
            String serviceEmailAccount;
            Optional<Boolean> enableServiceAccounts = EntriesCredentialConfiguration.maybeGetBoolean(entries, prefix + ENABLE_SERVICE_ACCOUNTS_SUFFIX);
            if (enableServiceAccounts.isPresent()) {
                this.setEnableServiceAccounts((Boolean)enableServiceAccounts.get());
            }
            if ((serviceEmailAccount = entries.get(prefix + SERVICE_ACCOUNT_EMAIL_SUFFIX)) != null) {
                this.setServiceAccountEmail(serviceEmailAccount);
            }
            if ((serviceAccountKeyFile = entries.get(prefix + SERVICE_ACCOUNT_KEYFILE_SUFFIX)) != null) {
                this.setServiceAccountKeyFile(serviceAccountKeyFile);
            }
            if ((serviceAccountJsonKeyFile = entries.get(prefix + JSON_KEYFILE_SUFFIX)) != null) {
                this.setServiceAccountJsonKeyFile(serviceAccountJsonKeyFile);
            }
            if ((clientId = entries.get(prefix + CLIENT_ID_SUFFIX)) != null) {
                this.setClientId(clientId);
            }
            if ((clientSecret = entries.get(prefix + CLIENT_SECRET_SUFFIX)) != null) {
                this.setClientSecret(clientSecret);
            }
            if ((oAuthCredentialPath = entries.get(prefix + OAUTH_CLIENT_FILE_SUFFIX)) != null) {
                this.setOAuthCredentialFile(oAuthCredentialPath);
            }
            if (!(enableNullCredential = EntriesCredentialConfiguration.maybeGetBoolean(entries, prefix + ENABLE_NULL_CREDENTIAL_SUFFIX)).isPresent()) continue;
            this.setNullCredentialEnabled((Boolean)enableNullCredential.get());
        }
    }

    public static class EntriesBuilder
    extends Builder<EntriesBuilder, EntriesCredentialConfiguration> {
        @Override
        public EntriesBuilder self() {
            return this;
        }

        @Override
        protected EntriesCredentialConfiguration beginBuild() {
            return new EntriesCredentialConfiguration(this.prefixes);
        }
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends EntriesCredentialConfiguration> {
        protected List<String> prefixes = new ArrayList<String>();
        private Entries configuration;
        private CredentialFactory credentialFactory = new CredentialFactory();

        public Builder() {
            this.prefixes.add(EntriesCredentialConfiguration.BASE_KEY_PREFIX);
        }

        protected abstract B self();

        protected abstract T beginBuild();

        public T build() {
            T concreteCredentialConfiguration = this.beginBuild();
            if (this.configuration != null) {
                ((EntriesCredentialConfiguration)concreteCredentialConfiguration).setConfiguration(this.configuration);
            }
            if (this.credentialFactory != null) {
                ((CredentialConfiguration)concreteCredentialConfiguration).setCredentialFactory(this.credentialFactory);
            }
            return concreteCredentialConfiguration;
        }

        @VisibleForTesting
        B withCredentialFactory(CredentialFactory credentialFactory) {
            this.credentialFactory = credentialFactory;
            return this.self();
        }

        public B withConfiguration(Entries configuration) {
            this.configuration = configuration;
            return this.self();
        }

        public B withOverridePrefix(String prefix) {
            this.prefixes.add(prefix);
            return this.self();
        }
    }

    public static interface Entries {
        public String get(String var1);

        public void set(String var1, String var2);

        public void setBoolean(String var1, boolean var2);
    }
}

