/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.storage.preprod.model;

/**
 * A subscription to receive Google PubSub notifications.
 *
 * <p>This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see: <a
 * href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceAccount extends com.google.api.client.json.GenericJson {

  /** The ID of the notification. The value may be {@code null}. */
  @com.google.api.client.util.Key("email_address")
  private String emailAddress;

  /**
   * The kind of item this is. For notifications, this is always storage#notification. The value may
   * be {@code null}.
   */
  @com.google.api.client.util.Key private String kind;

  /**
   * The ID of the notification.
   *
   * @return value or {@code null} for none
   */
  public String getEmailAddress() {
    return emailAddress;
  }

  /**
   * The ID of the notification.
   *
   * @param emailAddress emailAddress or {@code null} for none
   */
  public ServiceAccount setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * The kind of item this is. For notifications, this is always storage#notification.
   *
   * @return value or {@code null} for none
   */
  public String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For notifications, this is always storage#notification.
   *
   * @param kind kind or {@code null} for none
   */
  public ServiceAccount setKind(String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public ServiceAccount set(String fieldName, Object value) {
    return (ServiceAccount) super.set(fieldName, value);
  }

  @Override
  public ServiceAccount clone() {
    return (ServiceAccount) super.clone();
  }
}
