/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.storage.preprod.model;

import com.google.api.services.storage.model.ObjectAccessControl;

/**
 * An access-control list.
 *
 * <p>This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see: <a
 * href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ObjectAccessControls extends com.google.api.client.json.GenericJson {

  /** The list of items. The value may be {@code null}. */
  @com.google.api.client.util.Key
  private java.util.List<com.google.api.services.storage.model.ObjectAccessControl> items;

  static {
    // hack to force ProGuard to consider ObjectAccessControl used, since otherwise it would be
    // stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(
        com.google.api.services.storage.model.ObjectAccessControl.class);
  }

  /**
   * The kind of item this is. For lists of object access control entries, this is always
   * storage#objectAccessControls. The value may be {@code null}.
   */
  @com.google.api.client.util.Key private String kind;

  /**
   * The list of items.
   *
   * @return value or {@code null} for none
   */
  public java.util.List<com.google.api.services.storage.model.ObjectAccessControl> getItems() {
    return items;
  }

  /**
   * The list of items.
   *
   * @param items items or {@code null} for none
   */
  public ObjectAccessControls setItems(java.util.List<ObjectAccessControl> items) {
    this.items = items;
    return this;
  }

  /**
   * The kind of item this is. For lists of object access control entries, this is always
   * storage#objectAccessControls.
   *
   * @return value or {@code null} for none
   */
  public String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For lists of object access control entries, this is always
   * storage#objectAccessControls.
   *
   * @param kind kind or {@code null} for none
   */
  public ObjectAccessControls setKind(String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public ObjectAccessControls set(String fieldName, Object value) {
    return (ObjectAccessControls) super.set(fieldName, value);
  }

  @Override
  public ObjectAccessControls clone() {
    return (ObjectAccessControls) super.clone();
  }
}
