/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.storage.preprod.model;

/**
 * An access-control entry.
 *
 * <p>This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see: <a
 * href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BucketAccessControl extends com.google.api.client.json.GenericJson {

  /** The name of the bucket. The value may be {@code null}. */
  @com.google.api.client.util.Key private String bucket;

  /** The domain associated with the entity, if any. The value may be {@code null}. */
  @com.google.api.client.util.Key private String domain;

  /** The email address associated with the entity, if any. The value may be {@code null}. */
  @com.google.api.client.util.Key private String email;

  /**
   * The entity holding the permission, in one of the following forms: - user-userId - user-email -
   * group-groupId - group-email - domain-domain - project-team-projectId - allUsers -
   * allAuthenticatedUsers Examples: - The user liz@example.com would be user-liz@example.com. - The
   * group example@googlegroups.com would be group-example@googlegroups.com. - To refer to all
   * members of the Google Apps for Business domain example.com, the entity would be domain-
   * example.com. The value may be {@code null}.
   */
  @com.google.api.client.util.Key private String entity;

  /** The ID for the entity, if any. The value may be {@code null}. */
  @com.google.api.client.util.Key private String entityId;

  /** HTTP 1.1 Entity tag for the access-control entry. The value may be {@code null}. */
  @com.google.api.client.util.Key private String etag;

  /** The ID of the access-control entry. The value may be {@code null}. */
  @com.google.api.client.util.Key private String id;

  /**
   * The kind of item this is. For bucket access control entries, this is always
   * storage#bucketAccessControl. The value may be {@code null}.
   */
  @com.google.api.client.util.Key private String kind;

  /** The project team associated with the entity, if any. The value may be {@code null}. */
  @com.google.api.client.util.Key private ProjectTeam projectTeam;

  /** The access permission for the entity. The value may be {@code null}. */
  @com.google.api.client.util.Key private String role;

  /** The link to this access-control entry. The value may be {@code null}. */
  @com.google.api.client.util.Key private String selfLink;

  /**
   * The name of the bucket.
   *
   * @return value or {@code null} for none
   */
  public String getBucket() {
    return bucket;
  }

  /**
   * The name of the bucket.
   *
   * @param bucket bucket or {@code null} for none
   */
  public BucketAccessControl setBucket(String bucket) {
    this.bucket = bucket;
    return this;
  }

  /**
   * The domain associated with the entity, if any.
   *
   * @return value or {@code null} for none
   */
  public String getDomain() {
    return domain;
  }

  /**
   * The domain associated with the entity, if any.
   *
   * @param domain domain or {@code null} for none
   */
  public BucketAccessControl setDomain(String domain) {
    this.domain = domain;
    return this;
  }

  /**
   * The email address associated with the entity, if any.
   *
   * @return value or {@code null} for none
   */
  public String getEmail() {
    return email;
  }

  /**
   * The email address associated with the entity, if any.
   *
   * @param email email or {@code null} for none
   */
  public BucketAccessControl setEmail(String email) {
    this.email = email;
    return this;
  }

  /**
   * The entity holding the permission, in one of the following forms: - user-userId - user-email -
   * group-groupId - group-email - domain-domain - project-team-projectId - allUsers -
   * allAuthenticatedUsers Examples: - The user liz@example.com would be user-liz@example.com. - The
   * group example@googlegroups.com would be group-example@googlegroups.com. - To refer to all
   * members of the Google Apps for Business domain example.com, the entity would be domain-
   * example.com.
   *
   * @return value or {@code null} for none
   */
  public String getEntity() {
    return entity;
  }

  /**
   * The entity holding the permission, in one of the following forms: - user-userId - user-email -
   * group-groupId - group-email - domain-domain - project-team-projectId - allUsers -
   * allAuthenticatedUsers Examples: - The user liz@example.com would be user-liz@example.com. - The
   * group example@googlegroups.com would be group-example@googlegroups.com. - To refer to all
   * members of the Google Apps for Business domain example.com, the entity would be domain-
   * example.com.
   *
   * @param entity entity or {@code null} for none
   */
  public BucketAccessControl setEntity(String entity) {
    this.entity = entity;
    return this;
  }

  /**
   * The ID for the entity, if any.
   *
   * @return value or {@code null} for none
   */
  public String getEntityId() {
    return entityId;
  }

  /**
   * The ID for the entity, if any.
   *
   * @param entityId entityId or {@code null} for none
   */
  public BucketAccessControl setEntityId(String entityId) {
    this.entityId = entityId;
    return this;
  }

  /**
   * HTTP 1.1 Entity tag for the access-control entry.
   *
   * @return value or {@code null} for none
   */
  public String getEtag() {
    return etag;
  }

  /**
   * HTTP 1.1 Entity tag for the access-control entry.
   *
   * @param etag etag or {@code null} for none
   */
  public BucketAccessControl setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID of the access-control entry.
   *
   * @return value or {@code null} for none
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of the access-control entry.
   *
   * @param id id or {@code null} for none
   */
  public BucketAccessControl setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of item this is. For bucket access control entries, this is always
   * storage#bucketAccessControl.
   *
   * @return value or {@code null} for none
   */
  public String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For bucket access control entries, this is always
   * storage#bucketAccessControl.
   *
   * @param kind kind or {@code null} for none
   */
  public BucketAccessControl setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The project team associated with the entity, if any.
   *
   * @return value or {@code null} for none
   */
  public ProjectTeam getProjectTeam() {
    return projectTeam;
  }

  /**
   * The project team associated with the entity, if any.
   *
   * @param projectTeam projectTeam or {@code null} for none
   */
  public BucketAccessControl setProjectTeam(ProjectTeam projectTeam) {
    this.projectTeam = projectTeam;
    return this;
  }

  /**
   * The access permission for the entity.
   *
   * @return value or {@code null} for none
   */
  public String getRole() {
    return role;
  }

  /**
   * The access permission for the entity.
   *
   * @param role role or {@code null} for none
   */
  public BucketAccessControl setRole(String role) {
    this.role = role;
    return this;
  }

  /**
   * The link to this access-control entry.
   *
   * @return value or {@code null} for none
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * The link to this access-control entry.
   *
   * @param selfLink selfLink or {@code null} for none
   */
  public BucketAccessControl setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public BucketAccessControl set(String fieldName, Object value) {
    return (BucketAccessControl) super.set(fieldName, value);
  }

  @Override
  public BucketAccessControl clone() {
    return (BucketAccessControl) super.clone();
  }

  /** The project team associated with the entity, if any. */
  public static final class ProjectTeam extends com.google.api.client.json.GenericJson {

    /** The project number. The value may be {@code null}. */
    @com.google.api.client.util.Key private String projectNumber;

    /** The team. The value may be {@code null}. */
    @com.google.api.client.util.Key private String team;

    /**
     * The project number.
     *
     * @return value or {@code null} for none
     */
    public String getProjectNumber() {
      return projectNumber;
    }

    /**
     * The project number.
     *
     * @param projectNumber projectNumber or {@code null} for none
     */
    public ProjectTeam setProjectNumber(String projectNumber) {
      this.projectNumber = projectNumber;
      return this;
    }

    /**
     * The team.
     *
     * @return value or {@code null} for none
     */
    public String getTeam() {
      return team;
    }

    /**
     * The team.
     *
     * @param team team or {@code null} for none
     */
    public ProjectTeam setTeam(String team) {
      this.team = team;
      return this;
    }

    @Override
    public ProjectTeam set(String fieldName, Object value) {
      return (ProjectTeam) super.set(fieldName, value);
    }

    @Override
    public ProjectTeam clone() {
      return (ProjectTeam) super.clone();
    }
  }
}
