/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.ClientProto;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.google.storage.v1.StorageGrpc;
import com.google.google.storage.v1.StorageOuterClass;
import com.google.protobuf.util.Durations;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.alts.GoogleDefaultChannelBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class StorageStubProvider {
    private static final double GRPC_MAX_RETRY_ATTEMPTS = 10.0;
    private static final int MEDIA_CHANNEL_MAX_POOL_SIZE = 12;
    private static final String DEFAULT_GCS_GRPC_SERVER_ADDRESS = (String)StorageOuterClass.getDescriptor().findServiceByName("Storage").getOptions().getExtension(ClientProto.defaultHost);
    private final GoogleCloudStorageReadOptions readOptions;
    private final ExecutorService backgroundTasksThreadPool;
    private final List<ChannelAndRequestCounter> mediaChannelPool;

    public StorageStubProvider(GoogleCloudStorageReadOptions readOptions, ExecutorService backgroundTasksThreadPool) {
        this.readOptions = readOptions;
        this.backgroundTasksThreadPool = backgroundTasksThreadPool;
        this.mediaChannelPool = new ArrayList<ChannelAndRequestCounter>();
    }

    private ChannelAndRequestCounter buildManagedChannel() {
        ActiveRequestCounter counter = new ActiveRequestCounter();
        ManagedChannel channel = ((GoogleDefaultChannelBuilder)((GoogleDefaultChannelBuilder)GoogleDefaultChannelBuilder.forTarget((String)(Strings.isNullOrEmpty((String)this.readOptions.getGrpcServerAddress()) ? DEFAULT_GCS_GRPC_SERVER_ADDRESS : this.readOptions.getGrpcServerAddress())).defaultServiceConfig(this.getGrpcServiceConfig())).intercept(new ClientInterceptor[]{counter})).build();
        return new ChannelAndRequestCounter(channel, counter);
    }

    public synchronized StorageGrpc.StorageBlockingStub getBlockingStub() {
        ChannelAndRequestCounter channel;
        if (this.mediaChannelPool.size() < 12) {
            channel = this.buildManagedChannel();
            this.mediaChannelPool.add(channel);
        } else {
            channel = this.mediaChannelPool.stream().min(Comparator.comparingInt(ChannelAndRequestCounter::activeRequests)).get();
        }
        return StorageGrpc.newBlockingStub((Channel)channel.channel);
    }

    public synchronized StorageGrpc.StorageStub getAsyncStub() {
        ChannelAndRequestCounter channel;
        if (this.mediaChannelPool.size() < 12) {
            channel = this.buildManagedChannel();
            this.mediaChannelPool.add(channel);
        } else {
            channel = this.mediaChannelPool.stream().min(Comparator.comparingInt(ChannelAndRequestCounter::activeRequests)).get();
        }
        return (StorageGrpc.StorageStub)StorageGrpc.newStub((Channel)channel.channel).withExecutor(this.backgroundTasksThreadPool);
    }

    private Map<String, Object> getGrpcServiceConfig() {
        ImmutableMap name = ImmutableMap.of((Object)"service", (Object)"google.storage.v1.Storage");
        ImmutableMap retryPolicy = ImmutableMap.builder().put((Object)"maxAttempts", (Object)10.0).put((Object)"initialBackoff", (Object)Durations.fromMillis((long)this.readOptions.getBackoffInitialIntervalMillis()).toString()).put((Object)"maxBackoff", (Object)Durations.fromMillis((long)this.readOptions.getBackoffMaxIntervalMillis()).toString()).put((Object)"backoffMultiplier", (Object)this.readOptions.getBackoffMultiplier()).put((Object)"retryableStatusCodes", (Object)ImmutableList.of((Object)"UNAVAILABLE", (Object)"RESOURCE_EXHAUSTED")).build();
        ImmutableMap methodConfig = ImmutableMap.of((Object)"name", (Object)ImmutableList.of((Object)name), (Object)"retryPolicy", (Object)retryPolicy);
        ImmutableMap pickFirstStrategy = ImmutableMap.of((Object)"pick_first", (Object)ImmutableMap.of());
        ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)pickFirstStrategy));
        ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
        return ImmutableMap.of((Object)"methodConfig", (Object)ImmutableList.of((Object)methodConfig), (Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
    }

    public void shutdown() {
        this.mediaChannelPool.parallelStream().forEach(c -> ((ChannelAndRequestCounter)c).channel.shutdownNow());
    }

    class ChannelAndRequestCounter {
        private final ManagedChannel channel;
        private final ActiveRequestCounter counter;

        public ChannelAndRequestCounter(ManagedChannel channel, ActiveRequestCounter counter) {
            this.channel = channel;
            this.counter = counter;
        }

        public int activeRequests() {
            return this.counter.ongoingRequestCount.get();
        }
    }

    final class ActiveRequestCounter
    implements ClientInterceptor {
        private final AtomicInteger ongoingRequestCount = new AtomicInteger(0);

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
            ClientCall newCall = channel.newCall(methodDescriptor, callOptions);
            final AtomicBoolean countedCancel = new AtomicBoolean(false);
            Context.current().addListener(context -> {
                if (countedCancel.compareAndSet(false, true)) {
                    this.ongoingRequestCount.decrementAndGet();
                }
            }, (Executor)StorageStubProvider.this.backgroundTasksThreadPool);
            return new ForwardingClientCall.SimpleForwardingClientCall(newCall){

                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    if (countedCancel.compareAndSet(false, true)) {
                        ActiveRequestCounter.this.ongoingRequestCount.decrementAndGet();
                    }
                    super.cancel(message, cause);
                }

                public void start(ClientCall.Listener responseListener, Metadata headers) {
                    ActiveRequestCounter.this.ongoingRequestCount.incrementAndGet();
                    this.delegate().start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            if (countedCancel.compareAndSet(false, true)) {
                                ActiveRequestCounter.this.ongoingRequestCount.decrementAndGet();
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

