/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.system;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.LoggerBackend;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.Platform;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.Tags;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.system.BackendFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.system.Clock;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.system.EmptyLoggingContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.system.LoggingContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.system.SimpleBackendFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.system.StackBasedCallerFinder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.system.SystemClock;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.util.StaticMethodCaller;
import java.util.logging.Level;

public class DefaultPlatform
extends Platform {
    private static final String BACKEND_FACTORY = "flogger.backend_factory";
    private static final String LOGGING_CONTEXT = "flogger.logging_context";
    private static final String CLOCK = "flogger.clock";
    private final BackendFactory backendFactory;
    private final LoggingContext context;
    private final Clock clock;
    private final Platform.LogCallerFinder callerFinder;

    public DefaultPlatform() {
        BackendFactory factory = StaticMethodCaller.callGetterFromSystemProperty(BACKEND_FACTORY, BackendFactory.class);
        this.backendFactory = factory != null ? factory : SimpleBackendFactory.getInstance();
        LoggingContext context = StaticMethodCaller.callGetterFromSystemProperty(LOGGING_CONTEXT, LoggingContext.class);
        this.context = context != null ? context : EmptyLoggingContext.getInstance();
        Clock clock = StaticMethodCaller.callGetterFromSystemProperty(CLOCK, Clock.class);
        this.clock = clock != null ? clock : SystemClock.getInstance();
        this.callerFinder = StackBasedCallerFinder.getInstance();
    }

    DefaultPlatform(BackendFactory factory, LoggingContext context, Clock clock, Platform.LogCallerFinder callerFinder) {
        this.backendFactory = factory;
        this.context = context;
        this.clock = clock;
        this.callerFinder = callerFinder;
    }

    @Override
    protected Platform.LogCallerFinder getCallerFinderImpl() {
        return this.callerFinder;
    }

    @Override
    protected LoggerBackend getBackendImpl(String className) {
        return this.backendFactory.create(className);
    }

    @Override
    protected boolean shouldForceLoggingImpl(String loggerName, Level level, boolean isEnabled) {
        return this.context.shouldForceLogging(loggerName, level, isEnabled);
    }

    @Override
    protected Tags getInjectedTagsImpl() {
        return this.context.getTags();
    }

    @Override
    protected long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    @Override
    protected String getConfigInfoImpl() {
        return "Platform: " + this.getClass().getName() + "\nBackendFactory: " + this.backendFactory + "\nClock: " + this.clock + "\nLoggingContext: " + this.context + "\nLogCallerFinder: " + this.callerFinder + "\n";
    }
}

