/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ChannelLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.HttpConnectProxiedSocketAddress;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.AbstractManagedChannelImplBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.AtomicBackoff;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ClientTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ConnectionClientTransport;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.FixedObjectPool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.KeepAliveManager;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ManagedChannelImplBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ObjectPool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.SharedResourcePool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.TransportTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.NettyClientTransport;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiators;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.Utils;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelFactory;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ReflectiveChannelFactory;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1784")
@CanIgnoreReturnValue
public final class NettyChannelBuilder
extends AbstractManagedChannelImplBuilder<NettyChannelBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    private static final boolean DEFAULT_AUTO_FLOW_CONTROL;
    private static final long AS_LARGE_AS_INFINITE;
    private static final ChannelFactory<? extends Channel> DEFAULT_CHANNEL_FACTORY;
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_EVENT_LOOP_GROUP_POOL;
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    private final Map<ChannelOption<?>, Object> channelOptions = new HashMap();
    private NegotiationType negotiationType = NegotiationType.TLS;
    private ChannelFactory<? extends Channel> channelFactory = DEFAULT_CHANNEL_FACTORY;
    private ObjectPool<? extends EventLoopGroup> eventLoopGroupPool = DEFAULT_EVENT_LOOP_GROUP_POOL;
    private SslContext sslContext;
    private boolean autoFlowControl = DEFAULT_AUTO_FLOW_CONTROL;
    private int flowControlWindow = 0x100000;
    private int maxInboundMessageSize = 0x400000;
    private int maxHeaderListSize = 8192;
    private long keepAliveTimeNanos = Long.MAX_VALUE;
    private long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    private boolean keepAliveWithoutCalls;
    private ProtocolNegotiatorFactory protocolNegotiatorFactory;
    private LocalSocketPicker localSocketPicker;
    private final boolean useGetForSafeMethods = false;

    @CheckReturnValue
    public static NettyChannelBuilder forAddress(SocketAddress serverAddress) {
        return new NettyChannelBuilder(serverAddress);
    }

    @CheckReturnValue
    public static NettyChannelBuilder forAddress(String host, int port) {
        return new NettyChannelBuilder(host, port);
    }

    @CheckReturnValue
    public static NettyChannelBuilder forTarget(String target) {
        return new NettyChannelBuilder(target);
    }

    @CheckReturnValue
    NettyChannelBuilder(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    @CheckReturnValue
    NettyChannelBuilder(String target) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(target, new NettyChannelTransportFactoryBuilder(), new NettyChannelDefaultPortProvider());
    }

    @CheckReturnValue
    NettyChannelBuilder(SocketAddress address) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(address, NettyChannelBuilder.getAuthorityFromAddress(address), new NettyChannelTransportFactoryBuilder(), new NettyChannelDefaultPortProvider());
    }

    @Override
    @Internal
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    @CheckReturnValue
    private static String getAuthorityFromAddress(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            return GrpcUtil.authorityFromHostAndPort(inetAddress.getHostString(), inetAddress.getPort());
        }
        return address.toString();
    }

    public NettyChannelBuilder channelType(Class<? extends Channel> channelType) {
        Preconditions.checkNotNull(channelType, "channelType");
        return this.channelFactory(new ReflectiveChannelFactory<Channel>(channelType));
    }

    public NettyChannelBuilder channelFactory(ChannelFactory<? extends Channel> channelFactory) {
        this.channelFactory = Preconditions.checkNotNull(channelFactory, "channelFactory");
        return this;
    }

    public <T> NettyChannelBuilder withOption(ChannelOption<T> option, T value) {
        this.channelOptions.put(option, value);
        return this;
    }

    public NettyChannelBuilder negotiationType(NegotiationType type) {
        this.negotiationType = type;
        return this;
    }

    public NettyChannelBuilder eventLoopGroup(@Nullable EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup != null) {
            return this.eventLoopGroupPool(new FixedObjectPool<EventLoopGroup>(eventLoopGroup));
        }
        return this.eventLoopGroupPool(DEFAULT_EVENT_LOOP_GROUP_POOL);
    }

    NettyChannelBuilder eventLoopGroupPool(ObjectPool<? extends EventLoopGroup> eventLoopGroupPool) {
        this.eventLoopGroupPool = Preconditions.checkNotNull(eventLoopGroupPool, "eventLoopGroupPool");
        return this;
    }

    public NettyChannelBuilder sslContext(SslContext sslContext) {
        if (sslContext != null) {
            Preconditions.checkArgument(sslContext.isClient(), "Server SSL context can not be used for client channel");
            GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        }
        this.sslContext = sslContext;
        return this;
    }

    public NettyChannelBuilder initialFlowControlWindow(int initialFlowControlWindow) {
        Preconditions.checkArgument(initialFlowControlWindow > 0, "initialFlowControlWindow must be positive");
        this.flowControlWindow = initialFlowControlWindow;
        this.autoFlowControl = true;
        return this;
    }

    public NettyChannelBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument(flowControlWindow > 0, "flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        this.autoFlowControl = false;
        return this;
    }

    @Deprecated
    public NettyChannelBuilder maxHeaderListSize(int maxHeaderListSize) {
        return this.maxInboundMetadataSize(maxHeaderListSize);
    }

    @Override
    public NettyChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        this.maxHeaderListSize = bytes;
        return this;
    }

    @Override
    public NettyChannelBuilder usePlaintext() {
        this.negotiationType(NegotiationType.PLAINTEXT);
        return this;
    }

    @Override
    public NettyChannelBuilder useTransportSecurity() {
        this.negotiationType(NegotiationType.TLS);
        return this;
    }

    @Override
    public NettyChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTime > 0L, "keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    @Override
    public NettyChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTimeout > 0L, "keepalive timeout must be positive");
        this.keepAliveTimeoutNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos(this.keepAliveTimeoutNanos);
        return this;
    }

    @Override
    public NettyChannelBuilder keepAliveWithoutCalls(boolean enable) {
        this.keepAliveWithoutCalls = enable;
        return this;
    }

    public NettyChannelBuilder localSocketPicker(@Nullable LocalSocketPicker localSocketPicker) {
        this.localSocketPicker = localSocketPicker;
        return this;
    }

    @Override
    public NettyChannelBuilder maxInboundMessageSize(int max) {
        Preconditions.checkArgument(max >= 0, "negative max");
        this.maxInboundMessageSize = max;
        return this;
    }

    @CheckReturnValue
    ClientTransportFactory buildTransportFactory() {
        ProtocolNegotiator negotiator;
        this.assertEventLoopAndChannelType();
        if (this.protocolNegotiatorFactory != null) {
            negotiator = this.protocolNegotiatorFactory.buildProtocolNegotiator();
        } else {
            SslContext localSslContext = this.sslContext;
            if (this.negotiationType == NegotiationType.TLS && localSslContext == null) {
                try {
                    localSslContext = GrpcSslContexts.forClient().build();
                }
                catch (SSLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            negotiator = NettyChannelBuilder.createProtocolNegotiatorByType(this.negotiationType, localSslContext, this.managedChannelImplBuilder.getOffloadExecutorPool());
        }
        return new NettyTransportFactory(negotiator, this.channelFactory, this.channelOptions, this.eventLoopGroupPool, this.autoFlowControl, this.flowControlWindow, this.maxInboundMessageSize, this.maxHeaderListSize, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, this.transportTracerFactory, this.localSocketPicker, false);
    }

    @VisibleForTesting
    void assertEventLoopAndChannelType() {
        boolean bothProvided = this.channelFactory != DEFAULT_CHANNEL_FACTORY && this.eventLoopGroupPool != DEFAULT_EVENT_LOOP_GROUP_POOL;
        boolean nonProvided = this.channelFactory == DEFAULT_CHANNEL_FACTORY && this.eventLoopGroupPool == DEFAULT_EVENT_LOOP_GROUP_POOL;
        Preconditions.checkState(bothProvided || nonProvided, "Both EventLoopGroup and ChannelType should be provided or neither should be");
    }

    @CheckReturnValue
    int getDefaultPort() {
        switch (this.negotiationType) {
            case PLAINTEXT: 
            case PLAINTEXT_UPGRADE: {
                return 80;
            }
            case TLS: {
                return 443;
            }
        }
        throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
    }

    @CheckReturnValue
    @VisibleForTesting
    static ProtocolNegotiator createProtocolNegotiatorByType(NegotiationType negotiationType, SslContext sslContext, ObjectPool<? extends Executor> executorPool) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return ProtocolNegotiators.plaintext();
            }
            case PLAINTEXT_UPGRADE: {
                return ProtocolNegotiators.plaintextUpgrade();
            }
            case TLS: {
                return ProtocolNegotiators.tls(sslContext, executorPool);
            }
        }
        throw new IllegalArgumentException("Unsupported negotiationType: " + (Object)((Object)negotiationType));
    }

    NettyChannelBuilder disableCheckAuthority() {
        this.managedChannelImplBuilder.disableCheckAuthority();
        return this;
    }

    NettyChannelBuilder enableCheckAuthority() {
        this.managedChannelImplBuilder.enableCheckAuthority();
        return this;
    }

    void protocolNegotiatorFactory(ProtocolNegotiatorFactory protocolNegotiatorFactory) {
        this.protocolNegotiatorFactory = Preconditions.checkNotNull(protocolNegotiatorFactory, "protocolNegotiatorFactory");
    }

    void setTracingEnabled(boolean value) {
        this.managedChannelImplBuilder.setTracingEnabled(value);
    }

    void setStatsEnabled(boolean value) {
        this.managedChannelImplBuilder.setStatsEnabled(value);
    }

    void setStatsRecordStartedRpcs(boolean value) {
        this.managedChannelImplBuilder.setStatsRecordStartedRpcs(value);
    }

    void setStatsRecordFinishedRpcs(boolean value) {
        this.managedChannelImplBuilder.setStatsRecordFinishedRpcs(value);
    }

    void setStatsRecordRealTimeMetrics(boolean value) {
        this.managedChannelImplBuilder.setStatsRecordRealTimeMetrics(value);
    }

    @VisibleForTesting
    NettyChannelBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    static {
        AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
        DEFAULT_CHANNEL_FACTORY = new ReflectiveChannelFactory<Channel>(Utils.DEFAULT_CLIENT_CHANNEL_TYPE);
        DEFAULT_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP);
        String autoFlowControl = System.getenv("GRPC_EXPERIMENTAL_AUTOFLOWCONTROL");
        if (autoFlowControl == null) {
            autoFlowControl = "true";
        }
        DEFAULT_AUTO_FLOW_CONTROL = Boolean.parseBoolean(autoFlowControl);
    }

    @CheckReturnValue
    private static final class NettyTransportFactory
    implements ClientTransportFactory {
        private final ProtocolNegotiator protocolNegotiator;
        private final ChannelFactory<? extends Channel> channelFactory;
        private final Map<ChannelOption<?>, ?> channelOptions;
        private final ObjectPool<? extends EventLoopGroup> groupPool;
        private final EventLoopGroup group;
        private final boolean autoFlowControl;
        private final int flowControlWindow;
        private final int maxMessageSize;
        private final int maxHeaderListSize;
        private final AtomicBackoff keepAliveTimeNanos;
        private final long keepAliveTimeoutNanos;
        private final boolean keepAliveWithoutCalls;
        private final TransportTracer.Factory transportTracerFactory;
        private final LocalSocketPicker localSocketPicker;
        private final boolean useGetForSafeMethods;
        private boolean closed;

        NettyTransportFactory(ProtocolNegotiator protocolNegotiator, ChannelFactory<? extends Channel> channelFactory, Map<ChannelOption<?>, ?> channelOptions, ObjectPool<? extends EventLoopGroup> groupPool, boolean autoFlowControl, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeNanos, long keepAliveTimeoutNanos, boolean keepAliveWithoutCalls, TransportTracer.Factory transportTracerFactory, LocalSocketPicker localSocketPicker, boolean useGetForSafeMethods) {
            this.protocolNegotiator = Preconditions.checkNotNull(protocolNegotiator, "protocolNegotiator");
            this.channelFactory = channelFactory;
            this.channelOptions = new HashMap(channelOptions);
            this.groupPool = groupPool;
            this.group = groupPool.getObject();
            this.autoFlowControl = autoFlowControl;
            this.flowControlWindow = flowControlWindow;
            this.maxMessageSize = maxMessageSize;
            this.maxHeaderListSize = maxHeaderListSize;
            this.keepAliveTimeNanos = new AtomicBackoff("keepalive time nanos", keepAliveTimeNanos);
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            this.transportTracerFactory = transportTracerFactory;
            this.localSocketPicker = localSocketPicker != null ? localSocketPicker : new LocalSocketPicker();
            this.useGetForSafeMethods = useGetForSafeMethods;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            Preconditions.checkState(!this.closed, "The transport factory is closed.");
            ProtocolNegotiator localNegotiator = this.protocolNegotiator;
            HttpConnectProxiedSocketAddress proxiedAddr = options.getHttpConnectProxiedSocketAddress();
            if (proxiedAddr != null) {
                serverAddress = proxiedAddr.getTargetAddress();
                localNegotiator = ProtocolNegotiators.httpProxy(proxiedAddr.getProxyAddress(), proxiedAddr.getUsername(), proxiedAddr.getPassword(), this.protocolNegotiator);
            }
            final AtomicBackoff.State keepAliveTimeNanosState = this.keepAliveTimeNanos.getState();
            Runnable tooManyPingsRunnable = new Runnable(){

                @Override
                public void run() {
                    keepAliveTimeNanosState.backoff();
                }
            };
            NettyClientTransport transport = new NettyClientTransport(serverAddress, this.channelFactory, this.channelOptions, this.group, localNegotiator, this.autoFlowControl, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, keepAliveTimeNanosState.get(), this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, options.getAuthority(), options.getUserAgent(), tooManyPingsRunnable, this.transportTracerFactory.create(), options.getEagAttributes(), this.localSocketPicker, channelLogger, this.useGetForSafeMethods);
            return transport;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.group;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.protocolNegotiator.close();
            this.groupPool.returnObject(this.group);
        }
    }

    static interface ProtocolNegotiatorFactory {
        public ProtocolNegotiator buildProtocolNegotiator();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4917")
    public static class LocalSocketPicker {
        @Nullable
        public SocketAddress createSocketAddress(SocketAddress remoteAddress, Attributes attrs) {
            return null;
        }
    }

    private final class NettyChannelDefaultPortProvider
    implements ManagedChannelImplBuilder.ChannelBuilderDefaultPortProvider {
        private NettyChannelDefaultPortProvider() {
        }

        @Override
        public int getDefaultPort() {
            return NettyChannelBuilder.this.getDefaultPort();
        }
    }

    private final class NettyChannelTransportFactoryBuilder
    implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
        private NettyChannelTransportFactoryBuilder() {
        }

        @Override
        public ClientTransportFactory buildClientTransportFactory() {
            return NettyChannelBuilder.this.buildTransportFactory();
        }
    }
}

