/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts;

import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.CallCredentialsInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.CheckGcpEnvironment;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.HandshakerServiceChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.auth.MoreCallCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.SharedResourcePool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import javax.net.ssl.SSLException;

public final class ComputeEngineChannelBuilder
extends ForwardingChannelBuilder<ComputeEngineChannelBuilder> {
    private final NettyChannelBuilder delegate;

    private ComputeEngineChannelBuilder(String target) {
        SslContext sslContext;
        this.delegate = NettyChannelBuilder.forTarget(target);
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory(this.delegate(), new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext));
        CallCredentials credentials = MoreCallCredentials.from(ComputeEngineCredentials.create());
        Status status = Status.OK;
        if (!CheckGcpEnvironment.isOnGcp()) {
            status = Status.INTERNAL.withDescription("Compute Engine Credentials can only be used on Google Cloud Platform");
        }
        this.delegate().intercept(new ClientInterceptor[]{new CallCredentialsInterceptor(credentials, status)});
    }

    public static final ComputeEngineChannelBuilder forTarget(String target) {
        return new ComputeEngineChannelBuilder(target);
    }

    public static ComputeEngineChannelBuilder forAddress(String name, int port) {
        return ComputeEngineChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(name, port));
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    @VisibleForTesting
    InternalProtocolNegotiator.ProtocolNegotiator getProtocolNegotiatorForTest() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext).buildProtocolNegotiator();
    }
}

