/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.SystemUtils;

final class CheckGcpEnvironment {
    private static final Logger logger = Logger.getLogger(CheckGcpEnvironment.class.getName());
    private static final String DMI_PRODUCT_NAME = "/sys/class/dmi/id/product_name";
    private static final String WINDOWS_COMMAND = "powershell.exe";
    private static Boolean cachedResult = null;

    private CheckGcpEnvironment() {
    }

    static synchronized boolean isOnGcp() {
        if (cachedResult == null) {
            cachedResult = CheckGcpEnvironment.isRunningOnGcp();
        }
        return cachedResult;
    }

    @VisibleForTesting
    static boolean checkProductNameOnLinux(BufferedReader reader) throws IOException {
        String name = reader.readLine().trim();
        return name.equals("Google") || name.equals("Google Compute Engine");
    }

    @VisibleForTesting
    static boolean checkBiosDataOnWindows(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("Manufacturer")) continue;
            String name = line.substring(line.indexOf(58) + 1).trim();
            return name.equals("Google");
        }
        return false;
    }

    private static boolean isRunningOnGcp() {
        try {
            if (SystemUtils.IS_OS_LINUX) {
                return CheckGcpEnvironment.checkProductNameOnLinux(Files.newBufferedReader(Paths.get(DMI_PRODUCT_NAME, new String[0]), StandardCharsets.UTF_8));
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                Process p = new ProcessBuilder(new String[0]).command(WINDOWS_COMMAND, "Get-WmiObject", "-Class", "Win32_BIOS").start();
                return CheckGcpEnvironment.checkBiosDataOnWindows(new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8)));
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Fail to read platform information: ", e);
            return false;
        }
        return false;
    }
}

