/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.CheckGcpEnvironment;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.FailingClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.HandshakerServiceChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ObjectPool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.SharedResourcePool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsChannelBuilder
extends ForwardingChannelBuilder<AltsChannelBuilder> {
    private static final Logger logger = Logger.getLogger(AltsChannelBuilder.class.getName());
    private final NettyChannelBuilder delegate;
    private final ImmutableList.Builder<String> targetServiceAccountsBuilder = ImmutableList.builder();
    private ObjectPool<Channel> handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
    private boolean enableUntrustedAlts;

    public static final AltsChannelBuilder forTarget(String target) {
        return new AltsChannelBuilder(target);
    }

    public static AltsChannelBuilder forAddress(String name, int port) {
        return AltsChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(name, port));
    }

    private AltsChannelBuilder(String target) {
        this.delegate = NettyChannelBuilder.forTarget(target);
    }

    public AltsChannelBuilder addTargetServiceAccount(String targetServiceAccount) {
        this.targetServiceAccountsBuilder.add((Object)targetServiceAccount);
        return this;
    }

    public AltsChannelBuilder enableUntrustedAltsForTesting() {
        this.enableUntrustedAlts = true;
        return this;
    }

    public AltsChannelBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        this.handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.getHandshakerChannelForTesting(handshakerAddress));
        return this;
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    @Override
    public ManagedChannel build() {
        if (!CheckGcpEnvironment.isOnGcp()) {
            if (this.enableUntrustedAlts) {
                logger.log(Level.WARNING, "Untrusted ALTS mode is enabled and we cannot guarantee the trustworthiness of the ALTS handshaker service");
            } else {
                Status status = Status.INTERNAL.withDescription("ALTS is only allowed to run on Google Cloud Platform");
                this.delegate().intercept(new ClientInterceptor[]{new FailingClientInterceptor(status)});
            }
        }
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory(this.delegate(), new AltsProtocolNegotiator.ClientAltsProtocolNegotiatorFactory((List<String>)((Object)this.targetServiceAccountsBuilder.build()), this.handshakerChannelPool));
        return this.delegate().build();
    }

    @Nullable
    @VisibleForTesting
    InternalProtocolNegotiator.ProtocolNegotiator getProtocolNegotiatorForTest() {
        return new AltsProtocolNegotiator.ClientAltsProtocolNegotiatorFactory((List<String>)((Object)this.targetServiceAccountsBuilder.build()), this.handshakerChannelPool).buildProtocolNegotiator();
    }

    static final class FailingClientInterceptor
    implements ClientInterceptor {
        private final Status status;

        public FailingClientInterceptor(Status status) {
            this.status = status;
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new FailingClientCall(this.status);
        }
    }
}

