/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.BinaryLog;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.BindableService;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CompressorRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.DecompressorRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.HandlerRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Server;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerServiceDefinition;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerTransportFilter;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class ServerBuilder<T extends ServerBuilder<T>> {
    public static ServerBuilder<?> forPort(int port) {
        return ServerProvider.provider().builderForPort(port);
    }

    public abstract T directExecutor();

    public abstract T executor(@Nullable Executor var1);

    public abstract T addService(ServerServiceDefinition var1);

    public abstract T addService(BindableService var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/3117")
    public T intercept(ServerInterceptor interceptor) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2132")
    public T addTransportFilter(ServerTransportFilter filter) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        throw new UnsupportedOperationException();
    }

    public abstract T fallbackHandlerRegistry(@Nullable HandlerRegistry var1);

    public abstract T useTransportSecurity(File var1, File var2);

    public T useTransportSecurity(InputStream certChain, InputStream privateKey) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
    public abstract T decompressorRegistry(@Nullable DecompressorRegistry var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
    public abstract T compressorRegistry(@Nullable CompressorRegistry var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/3706")
    public T handshakeTimeout(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public T maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument(bytes >= 0, "bytes must be >= 0");
        return this.thisT();
    }

    public T maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        return this.thisT();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4017")
    public T setBinaryLog(BinaryLog binaryLog) {
        throw new UnsupportedOperationException();
    }

    public abstract Server build();

    private T thisT() {
        ServerBuilder thisT = this;
        return (T)thisT;
    }
}

