/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.testing;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HadoopConfigurationProperty;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HadoopConfigurationUtils {
    public static Map<String, ?> getDefaultProperties(Class<?> configurationClass) {
        return Arrays.stream(configurationClass.getDeclaredFields()).filter(f -> HadoopConfigurationProperty.class.isAssignableFrom(f.getType())).map(HadoopConfigurationUtils::getDefaultProperty).collect(HashMap::new, (map, p) -> {
            for (String deprecatedKey : p.getDeprecatedKeys()) {
                map.put(deprecatedKey, p.getDefault());
            }
            map.put(p.getKey(), p.getDefault());
        }, HashMap::putAll);
    }

    private static HadoopConfigurationProperty<?> getDefaultProperty(Field field) {
        try {
            return (HadoopConfigurationProperty)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to get '%s' field value", field.getName()), e);
        }
    }

    private HadoopConfigurationUtils() {
    }
}

