/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CreateObjectOptions {
    public static final ImmutableMap<String, byte[]> EMPTY_METADATA = ImmutableMap.of();
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_CONTENT_ENCODING = null;
    public static final CreateObjectOptions DEFAULT = new CreateObjectOptions(true);
    private final boolean overwriteExisting;
    private final String contentType;
    private final String contentEncoding;
    private final Map<String, byte[]> metadata;
    private final boolean requireMetadataMatchForEmptyObjects;

    public CreateObjectOptions(boolean overwriteExisting) {
        this(overwriteExisting, DEFAULT_CONTENT_TYPE, DEFAULT_CONTENT_ENCODING, EMPTY_METADATA, false);
    }

    public CreateObjectOptions(boolean overwriteExisting, Map<String, byte[]> metadata) {
        this(overwriteExisting, DEFAULT_CONTENT_TYPE, metadata);
    }

    public CreateObjectOptions(boolean overwriteExisting, String contentType, Map<String, byte[]> metadata) {
        this(overwriteExisting, contentType, DEFAULT_CONTENT_ENCODING, metadata, true);
    }

    public CreateObjectOptions(boolean overwriteExisting, String contentType, String contentEncoding, Map<String, byte[]> metadata, boolean requireMetadataMatchForEmptyObjects) {
        Preconditions.checkArgument(!metadata.containsKey("Content-Type"), "The Content-Type must be provided explicitly via the 'contentType' parameter");
        Preconditions.checkArgument(!metadata.containsKey("Content-Encoding"), "The Content-Encoding must be provided explicitly via the 'contentEncoding' parameter");
        this.overwriteExisting = overwriteExisting;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.metadata = metadata;
        this.requireMetadataMatchForEmptyObjects = requireMetadataMatchForEmptyObjects;
    }

    public boolean overwriteExisting() {
        return this.overwriteExisting;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public Map<String, byte[]> getMetadata() {
        return this.metadata;
    }

    public boolean getRequireMetadataMatchForEmptyObjects() {
        return this.requireMetadataMatchForEmptyObjects;
    }
}

