/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyUtil {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPropertyOrDefault(Class<?> referenceClass, String propertyFile, String key, String defaultValue) {
        try (InputStream stream = referenceClass.getResourceAsStream(propertyFile);){
            if (stream == null) {
                ((GoogleLogger.Api)logger.atSevere()).log("Could not load properties file '%s'", propertyFile);
                String string = defaultValue;
                return string;
            }
            Properties properties = new Properties();
            properties.load(stream);
            String value = properties.getProperty(key);
            if (value == null) {
                ((GoogleLogger.Api)logger.atSevere()).log("Key %s not found in properties file %s.", (Object)key, (Object)propertyFile);
                String string = defaultValue;
                return string;
            }
            String string = value;
            return string;
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Error while trying to get property value for key %s", key);
            return defaultValue;
        }
    }
}

