/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CredentialConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Optional;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class EntriesCredentialConfiguration
extends CredentialConfiguration {
    public static final String BASE_KEY_PREFIX = "google.cloud";
    public static final String ENABLE_SERVICE_ACCOUNTS_SUFFIX = ".auth.service.account.enable";
    public static final String SERVICE_ACCOUNT_EMAIL_SUFFIX = ".auth.service.account.email";
    public static final String SERVICE_ACCOUNT_PRIVATE_KEY_ID_SUFFIX = ".auth.service.account.private.key.id";
    public static final String SERVICE_ACCOUNT_PRIVATE_KEY_SUFFIX = ".auth.service.account.private.key";
    public static final String SERVICE_ACCOUNT_KEYFILE_SUFFIX = ".auth.service.account.keyfile";
    public static final String JSON_KEYFILE_SUFFIX = ".auth.service.account.json.keyfile";
    public static final String CLIENT_ID_SUFFIX = ".auth.client.id";
    public static final String CLIENT_SECRET_SUFFIX = ".auth.client.secret";
    public static final String OAUTH_CLIENT_FILE_SUFFIX = ".auth.client.file";
    public static final String ENABLE_NULL_CREDENTIAL_SUFFIX = ".auth.null.enable";
    public static final String PROXY_ADDRESS_KEY = "fs.gs.proxy.address";
    public static final String PROXY_ADDRESS_DEFAULT = null;
    public static final String PROXY_USERNAME_KEY = "fs.gs.proxy.username";
    public static final String PROXY_USERNAME_DEFAULT = null;
    public static final String PROXY_PASSWORD_KEY = "fs.gs.proxy.password";
    public static final String PROXY_PASSWORD_DEFAULT = null;
    public static final String HTTP_TRANSPORT_KEY = "fs.gs.http.transport.type";
    public static final HttpTransportFactory.HttpTransportType HTTP_TRANSPORT_DEFAULT = HttpTransportFactory.DEFAULT_TRANSPORT_TYPE;
    private final List<String> prefixes;

    public static EntriesBuilder newEntriesBuilder() {
        return new EntriesBuilder();
    }

    private static Optional<Boolean> maybeGetBoolean(Entries config, String key) {
        String value = config.get(key);
        if (value == null) {
            return Optional.absent();
        }
        return Optional.of(Boolean.valueOf(value));
    }

    public EntriesCredentialConfiguration(List<String> prefixes) {
        this.prefixes = ImmutableList.copyOf(prefixes);
    }

    public void getConfigurationInto(Entries configuration) {
        for (String prefix : this.prefixes) {
            configuration.setBoolean(prefix + ENABLE_SERVICE_ACCOUNTS_SUFFIX, this.isServiceAccountEnabled());
            if (this.getServiceAccountEmail() != null) {
                configuration.set(prefix + SERVICE_ACCOUNT_EMAIL_SUFFIX, this.getServiceAccountEmail());
            }
            if (this.getServiceAccountPrivateKeyId() != null) {
                configuration.set(prefix + SERVICE_ACCOUNT_PRIVATE_KEY_ID_SUFFIX, this.getServiceAccountPrivateKeyId());
            }
            if (this.getServiceAccountPrivateKey() != null) {
                configuration.set(prefix + SERVICE_ACCOUNT_PRIVATE_KEY_SUFFIX, this.getServiceAccountPrivateKey());
            }
            if (this.getServiceAccountKeyFile() != null) {
                configuration.set(prefix + SERVICE_ACCOUNT_KEYFILE_SUFFIX, this.getServiceAccountKeyFile());
            }
            if (this.getServiceAccountJsonKeyFile() != null) {
                configuration.set(prefix + JSON_KEYFILE_SUFFIX, this.getServiceAccountJsonKeyFile());
            }
            if (this.getClientId() != null) {
                configuration.set(prefix + CLIENT_ID_SUFFIX, this.getClientId());
            }
            if (this.getClientSecret() != null) {
                configuration.set(prefix + CLIENT_SECRET_SUFFIX, this.getClientSecret());
            }
            if (this.getOAuthCredentialFile() != null) {
                configuration.set(prefix + OAUTH_CLIENT_FILE_SUFFIX, this.getOAuthCredentialFile());
            }
            configuration.setBoolean(prefix + ENABLE_NULL_CREDENTIAL_SUFFIX, this.isNullCredentialEnabled());
        }
        if (this.getProxyAddress() != null) {
            configuration.set(PROXY_ADDRESS_KEY, this.getProxyAddress());
        }
        if (this.getProxyUsername() != null) {
            configuration.set(PROXY_USERNAME_KEY, this.getProxyUsername());
        }
        if (this.getProxyPassword() != null) {
            configuration.set(PROXY_PASSWORD_KEY, this.getProxyPassword());
        }
        configuration.set(HTTP_TRANSPORT_KEY, this.getTransportType().name());
    }

    public void setConfiguration(Entries entries) {
        String transportType;
        String proxyPassword;
        String proxyUsername;
        for (String prefix : this.prefixes) {
            Optional<Boolean> enableNullCredential;
            String oAuthCredentialPath;
            String clientSecret;
            String clientId;
            String serviceAccountJsonKeyFile;
            String serviceAccountKeyFile;
            String serviceAccountPrivateKey;
            String serviceAccountPrivateKeyId;
            String serviceEmailAccount;
            Optional<Boolean> enableServiceAccounts = EntriesCredentialConfiguration.maybeGetBoolean(entries, prefix + ENABLE_SERVICE_ACCOUNTS_SUFFIX);
            if (enableServiceAccounts.isPresent()) {
                this.setEnableServiceAccounts(enableServiceAccounts.get());
            }
            if ((serviceEmailAccount = entries.getPassword(prefix + SERVICE_ACCOUNT_EMAIL_SUFFIX)) != null) {
                this.setServiceAccountEmail(serviceEmailAccount);
            }
            if ((serviceAccountPrivateKeyId = entries.getPassword(prefix + SERVICE_ACCOUNT_PRIVATE_KEY_ID_SUFFIX)) != null) {
                this.setServiceAccountPrivateKeyId(serviceAccountPrivateKeyId);
            }
            if ((serviceAccountPrivateKey = entries.getPassword(prefix + SERVICE_ACCOUNT_PRIVATE_KEY_SUFFIX)) != null) {
                this.setServiceAccountPrivateKey(serviceAccountPrivateKey);
            }
            if ((serviceAccountKeyFile = entries.get(prefix + SERVICE_ACCOUNT_KEYFILE_SUFFIX)) != null) {
                this.setServiceAccountKeyFile(serviceAccountKeyFile);
            }
            if ((serviceAccountJsonKeyFile = entries.get(prefix + JSON_KEYFILE_SUFFIX)) != null) {
                this.setServiceAccountJsonKeyFile(serviceAccountJsonKeyFile);
            }
            if ((clientId = entries.get(prefix + CLIENT_ID_SUFFIX)) != null) {
                this.setClientId(clientId);
            }
            if ((clientSecret = entries.get(prefix + CLIENT_SECRET_SUFFIX)) != null) {
                this.setClientSecret(clientSecret);
            }
            if ((oAuthCredentialPath = entries.get(prefix + OAUTH_CLIENT_FILE_SUFFIX)) != null) {
                this.setOAuthCredentialFile(oAuthCredentialPath);
            }
            if (!(enableNullCredential = EntriesCredentialConfiguration.maybeGetBoolean(entries, prefix + ENABLE_NULL_CREDENTIAL_SUFFIX)).isPresent()) continue;
            this.setNullCredentialEnabled(enableNullCredential.get());
        }
        String proxyAddress = entries.get(PROXY_ADDRESS_KEY);
        if (proxyAddress != null) {
            this.setProxyAddress(proxyAddress);
        }
        if ((proxyUsername = entries.getPassword(PROXY_USERNAME_KEY)) != null) {
            this.setProxyUsername(proxyUsername);
        }
        if ((proxyPassword = entries.getPassword(PROXY_PASSWORD_KEY)) != null) {
            this.setProxyPassword(proxyPassword);
        }
        if ((transportType = entries.get(HTTP_TRANSPORT_KEY)) != null) {
            this.setTransportType(HttpTransportFactory.HttpTransportType.valueOf(transportType));
        }
    }

    public static class EntriesBuilder
    extends Builder<EntriesBuilder, EntriesCredentialConfiguration> {
        @Override
        public EntriesBuilder self() {
            return this;
        }

        @Override
        protected EntriesCredentialConfiguration beginBuild() {
            return new EntriesCredentialConfiguration(this.prefixes);
        }
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends EntriesCredentialConfiguration> {
        protected List<String> prefixes = new ArrayList<String>();
        private Entries configuration;
        private CredentialFactory credentialFactory = new CredentialFactory();

        public Builder() {
            this.prefixes.add(EntriesCredentialConfiguration.BASE_KEY_PREFIX);
        }

        protected abstract B self();

        protected abstract T beginBuild();

        public T build() {
            T concreteCredentialConfiguration = this.beginBuild();
            if (this.configuration != null) {
                ((EntriesCredentialConfiguration)concreteCredentialConfiguration).setConfiguration(this.configuration);
            }
            if (this.credentialFactory != null) {
                ((CredentialConfiguration)concreteCredentialConfiguration).setCredentialFactory(this.credentialFactory);
            }
            return concreteCredentialConfiguration;
        }

        @VisibleForTesting
        B withCredentialFactory(CredentialFactory credentialFactory) {
            this.credentialFactory = credentialFactory;
            return this.self();
        }

        public B withConfiguration(Entries configuration) {
            this.configuration = configuration;
            return this.self();
        }

        public B withOverridePrefix(String prefix) {
            this.prefixes.add(prefix);
            return this.self();
        }
    }

    public static interface Entries {
        public String get(String var1);

        public void set(String var1, String var2);

        public void setBoolean(String var1, boolean var2);

        public String getPassword(String var1);
    }
}

